/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing;

import com.paterva.maltego.typing.editing.controls.AttachPanelController;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.ui.progress.ProgressDescriptor;
import com.paterva.maltego.util.ui.progress.ProgressDialogFactory;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public abstract class AbstractAddAttachmentsAction
extends NodeAction {
    protected abstract void attachFile(Object var1, File var2, FastURL var3) throws IOException;

    protected abstract void attachFile(List var1, File var2, FastURL var3) throws IOException;

    protected abstract void done();

    protected void perform(List list) {
        AttachPanelController attachPanelController = new AttachPanelController();
        EditDialogDescriptor editDialogDescriptor = new EditDialogDescriptor("Attach File(s)/URL(s)", (WizardDescriptor.Panel)attachPanelController);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)editDialogDescriptor) == EditDialogDescriptor.OK_OPTION) {
            Object object = editDialogDescriptor.getProperty("attachSource");
            if (AttachPanelController.SOURCE_FILES.equals(object)) {
                List list2 = (List)editDialogDescriptor.getProperty("sourceFiles");
                this.attachFiles(list, list2);
            } else if (AttachPanelController.SOURCE_URLS.equals(object)) {
                List list3 = (List)editDialogDescriptor.getProperty("sourceURLs");
                this.attachURLs(list, list3);
            }
        }
    }

    public void attachFiles(final List list, final List<File> list2) {
        ProgressDescriptor progressDescriptor = ProgressDialogFactory.createProgressDialog((String)"Attaching File(s)", (boolean)true);
        final ProgressController progressController = progressDescriptor.getController();
        Component component = progressDescriptor.getGUIComponent();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                progressController.start(list.size() * list2.size());
                int n = 0;
                for (File file : list2) {
                    if (progressController.isCanceled()) break;
                    String string = String.format("(%d/%d) Attaching %s", n + 1, list2.size(), file.getName());
                    progressController.progress(string, n);
                    ++n;
                    try {
                        AbstractAddAttachmentsAction.this.attachFile(list, file, new FastURL(file.toURI().toURL().toString()));
                    }
                    catch (IOException iOException) {
                        AbstractAddAttachmentsAction.this.showError("Unable to attach " + file.getName());
                    }
                }
                progressController.finish();
                AbstractAddAttachmentsAction.this.onDone();
            }
        });
        thread.start();
        component.setVisible(true);
    }

    public void attachFiles(final Map<Object, File> map) {
        ProgressDescriptor progressDescriptor = ProgressDialogFactory.createProgressDialog((String)"Attaching File(s)", (boolean)true);
        final ProgressController progressController = progressDescriptor.getController();
        Component component = progressDescriptor.getGUIComponent();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                progressController.start(map.size());
                int n = 0;
                for (Map.Entry entry : map.entrySet()) {
                    Object k = entry.getKey();
                    File file = (File)entry.getValue();
                    if (progressController.isCanceled()) break;
                    String string = String.format("(%d/%d) Attaching %s", n + 1, map.size(), file.getName());
                    progressController.progress(string, n);
                    ++n;
                    try {
                        AbstractAddAttachmentsAction.this.attachFile(k, file, new FastURL(file.toURI().toURL().toString()));
                    }
                    catch (IOException iOException) {
                        AbstractAddAttachmentsAction.this.showError("Unable to attach " + file.getName());
                    }
                }
                progressController.finish();
                AbstractAddAttachmentsAction.this.onDone();
            }
        });
        thread.start();
        component.setVisible(true);
    }

    protected void attachURLs(final List list, final List<FastURL> list2) {
        ProgressDescriptor progressDescriptor = ProgressDialogFactory.createProgressDialog((String)"Attaching URL(s)", (boolean)true);
        final ProgressController progressController = progressDescriptor.getController();
        Component component = progressDescriptor.getGUIComponent();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    progressController.start(list2.size() * 100);
                    int n = 0;
                    String string = FileUtilities.createTempDir((String)"FromURL");
                    for (final FastURL fastURL : list2) {
                        if (progressController.isCanceled()) {
                            break;
                        }
                        String string2 = String.format("(%d/%d) Downloading %s", n + 1, list2.size(), fastURL.toString());
                        progressController.progress(string2, n * 100);
                        FileUtilities.deleteContents((File)new File(string));
                        InputStream inputStream = null;
                        try {
                            Object object;
                            URL uRL = fastURL.getURL();
                            int n2 = uRL.openConnection().getContentLength();
                            inputStream = uRL.openStream();
                            String string3 = new File(uRL.getPath()).getName();
                            File file = new File(string + string3);
                            FileOutputStream fileOutputStream = null;
                            try {
                                object = new byte[1024];
                                fileOutputStream = new FileOutputStream(file);
                                int n3 = inputStream.read((byte[])object, 0, ((byte[])object).length);
                                int n4 = 0;
                                while (n3 > 0) {
                                    n4 += n3;
                                    if (n2 > 0) {
                                        int n5 = n * 100 + n4 * 100 / n2;
                                        progressController.progress(n5);
                                    }
                                    if (progressController.isCanceled()) {
                                        break;
                                    }
                                    fileOutputStream.write((byte[])object, 0, n3);
                                    n3 = inputStream.read((byte[])object, 0, ((byte[])object).length);
                                }
                            }
                            finally {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                            }
                            if (progressController.isCanceled()) break;
                            if (!string3.contains(".")) {
                                object = ImageUtils.getImageFormatName((Object)file);
                                File file2 = new File(file.getAbsolutePath() + "." + ((String)object).toLowerCase());
                                if (file.renameTo(file2)) {
                                    file = file2;
                                }
                            }
                            string2 = String.format("(%d/%d) Attaching %s", n + 1, list2.size(), file.getName());
                            progressController.progress(string2);
                            AbstractAddAttachmentsAction.this.attachFile(list, file, fastURL);
                        }
                        catch (IOException iOException) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Unable to attach " + fastURL), 0);
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                    }
                                });
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                finally {
                    progressController.finish();
                    AbstractAddAttachmentsAction.this.onDone();
                }
            }
        });
        thread.start();
        component.setVisible(true);
    }

    private void onDone() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AbstractAddAttachmentsAction.this.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void showError(final String string) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

