/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.io.wizard.SamplingPanel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import javax.swing.JComponent;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

public class SamplingController
extends ValidatingController<SamplingPanel>
implements WizardDescriptor.ValidatingPanel {
    public SamplingController() {
        this.setName("Sampling");
    }

    protected SamplingPanel createComponent() {
        return new SamplingPanel();
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        ((SamplingPanel)this.component()).setSamplingEnabled(TabularGraphImportOptions.isSamplingEnabled());
        ((SamplingPanel)this.component()).setSamplingRate(TabularGraphImportOptions.getSamplingRate());
        ((SamplingPanel)this.component()).setLimitEnabled(TabularGraphImportOptions.isEntityLimitEnabled());
        ((SamplingPanel)this.component()).setLimit(TabularGraphImportOptions.getEntityLimit());
        ((SamplingPanel)this.component()).setMergeLinks(TabularGraphImportOptions.isMergeLinks());
    }

    protected void storeSettings(WizardDescriptor wizardDescriptor) {
    }

    public void validate() throws WizardValidationException {
        String string = this.checkNumberAboveZero("row sampling rate", ((SamplingPanel)this.component()).getSamplingRate());
        if (string == null) {
            string = this.checkNumberAboveZero("entity limit", ((SamplingPanel)this.component()).getLimit());
        }
        if (string == null) {
            TabularGraphImportOptions.setSamplingEnabled(((SamplingPanel)this.component()).getSamplingEnabled());
            TabularGraphImportOptions.setSamplingRate(Integer.parseInt(((SamplingPanel)this.component()).getSamplingRate()));
            TabularGraphImportOptions.setEntityLimitEnabled(((SamplingPanel)this.component()).getLimitEnabled());
            TabularGraphImportOptions.setEntityLimit(Integer.parseInt(((SamplingPanel)this.component()).getLimit()));
            TabularGraphImportOptions.setMergeLinks(((SamplingPanel)this.component()).getMergeLinks());
        }
        if (string != null) {
            throw new WizardValidationException((JComponent)this.component(), string, string);
        }
    }

    private String checkNumberAboveZero(String string, String string2) {
        String string3 = "The %s must be an integer greater than 0";
        String string4 = null;
        try {
            int n = Integer.parseInt(string2);
            if (n <= 0) {
                string4 = String.format("The %s must be an integer greater than 0", string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            string4 = String.format("The %s must be an integer greater than 0", string);
        }
        return string4;
    }
}

