/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.entity.api.MaltegoPartSpec;
import com.paterva.maltego.graph.table.io.api.PropertyToColumnMap;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editing.AddPropertyFormController;
import com.paterva.maltego.util.ArrayUtilities;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.WeakListeners;

public abstract class PropertyTableModel
extends AbstractTableModel {
    private static final int COLUMN_NAME_COLUMN = 0;
    private static final int PROPERTY_DISPLAY_NAME_COLUMN = 1;
    private static final int PROPERTY_NAME_COLUMN = 2;
    private static final int PROPERTY_TYPE_COLUMN = 3;
    private static final String[] _columnNames = new String[]{"Column", "Property", "Property Name", "Property Type"};
    private static final String _newProperty = "New...";
    private static Map<Object, Set<DisplayDescriptor>> _dynamicProperties = new HashMap<Object, Set<DisplayDescriptor>>();
    private TabularGraph _tabularGraph;
    private PropertyToColumnMap _map;
    private ETable _table;
    private TabularGraphListener _graphListener;
    private MapListener _mapListener;
    private boolean _createdDeleteButton = false;

    protected abstract MaltegoPartSpec getSpec(PropertyToColumnMap var1);

    protected abstract DisplayDescriptorCollection getTypeProperties(PropertyToColumnMap var1);

    protected abstract boolean isMapped(TabularGraph var1, MaltegoPartSpec var2, PropertyDescriptor var3);

    public void setTabularGraph(TabularGraph tabularGraph) {
        _dynamicProperties.clear();
        this._tabularGraph = tabularGraph;
        this._graphListener = new TabularGraphListener();
        this._tabularGraph.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._graphListener, (Object)this._tabularGraph));
        this.createDeleteButton();
    }

    public void setMap(PropertyToColumnMap propertyToColumnMap) {
        this._map = propertyToColumnMap;
        if (this._map != null) {
            this.removeUnusedDynamicProperties(this.getSpec(this._map));
            this._mapListener = new MapListener();
            this._map.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._mapListener, (Object)this._map));
        }
        this.updatePropertyCombo();
        this.fireTableDataChanged();
    }

    public PropertyToColumnMap getMap() {
        return this._map;
    }

    public JTable getTable() {
        if (this._table == null) {
            this._table = new ETable((TableModel)this);
            this._table.setFillsViewportHeight(true);
            this._table.setSelectionMode(0);
            this._table.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        }
        return this._table;
    }

    @Override
    public String getColumnName(int n) {
        return _columnNames[n];
    }

    @Override
    public int getRowCount() {
        if (this._tabularGraph == null || this._map == null) {
            return 0;
        }
        return this._map.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return _columnNames.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._tabularGraph == null || this._map == null) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = this._map.getProperty(this._map.getColumns()[n]);
        switch (n2) {
            case 0: {
                return this._tabularGraph.getColumnNames()[this._map.getColumns()[n]];
            }
            case 1: {
                return propertyDescriptor != null ? propertyDescriptor.getDisplayName() : "";
            }
            case 2: {
                return propertyDescriptor != null ? propertyDescriptor.getName() : "";
            }
            case 3: {
                if (propertyDescriptor != null) {
                    return TypeRegistry.getDefault().getType(propertyDescriptor.getType()).getTypeName();
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            int n3 = this._map.getColumns()[n];
            PropertyDescriptor propertyDescriptor = null;
            if (object instanceof PropertyDescriptor) {
                propertyDescriptor = (PropertyDescriptor)object;
            } else if (object == _newProperty) {
                propertyDescriptor = this.createDynamicProperty();
            }
            this._map.put(n3, propertyDescriptor);
        }
    }

    protected PropertyDescriptor createDynamicProperty() {
        DisplayDescriptor displayDescriptor = null;
        EditDialogDescriptor editDialogDescriptor = new EditDialogDescriptor("Add New Property", (WizardDescriptor.Panel)new AddPropertyFormController());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)editDialogDescriptor) == EditDialogDescriptor.OK_OPTION) {
            String string = (String)editDialogDescriptor.getProperty("uniqueName");
            TypeDescriptor typeDescriptor = (TypeDescriptor)editDialogDescriptor.getProperty("typeDescriptor");
            String string2 = (String)editDialogDescriptor.getProperty("displayName");
            displayDescriptor = new DisplayDescriptor(typeDescriptor.getType(), string, string2);
            if (Date.class.equals((Object)displayDescriptor.getTypeDescriptor().getType())) {
                displayDescriptor.setFormat((Format)new SimpleDateFormat("yyyy/MM/dd"));
            }
            this.addDynamicProperty(displayDescriptor);
        }
        return displayDescriptor;
    }

    protected void addDynamicProperty(DisplayDescriptor displayDescriptor) {
        Set<DisplayDescriptor> set = _dynamicProperties.get(this.getSpec(this._map));
        if (set == null) {
            set = new HashSet<DisplayDescriptor>();
            _dynamicProperties.put(this.getSpec(this._map), set);
        }
        set.add(displayDescriptor);
        this.updatePropertyCombo();
    }

    protected void updatePropertyCombo() {
        if (this._tabularGraph != null && this._map != null) {
            TableColumn tableColumn = this._table.getColumnModel().getColumn(1);
            DisplayDescriptorCollection displayDescriptorCollection = this.getTypeProperties(this._map);
            Set<DisplayDescriptor> set = _dynamicProperties.get(this.getSpec(this._map));
            HashSet<DisplayDescriptor> hashSet = new HashSet<DisplayDescriptor>((Collection<DisplayDescriptor>)displayDescriptorCollection);
            if (set != null) {
                hashSet.addAll(set);
            }
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.addItem("");
            for (DisplayDescriptor displayDescriptor : hashSet) {
                jComboBox.addItem((String)displayDescriptor);
            }
            jComboBox.addItem(_newProperty);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        }
    }

    protected void createDeleteButton() {
        if (this._createdDeleteButton) {
            return;
        }
        EditableTableDecorator editableTableDecorator = new EditableTableDecorator();
        editableTableDecorator.addEditDelete((JTable)this._table, new TableButtonListener(){

            public void actionPerformed(TableButtonEvent tableButtonEvent) {
                int[] nArray = tableButtonEvent.getSelectedRows();
                ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
                for (int n : nArray) {
                    arrayList.add(PropertyTableModel.this._map.getColumns()[PropertyTableModel.this._table.convertRowIndexToModel(n)]);
                }
                Integer[] integerArray = arrayList.toArray(new Integer[arrayList.size()]);
                PropertyTableModel.this._tabularGraph.remove(ArrayUtilities.toPrimitiveArray((Integer[])integerArray));
            }
        }, null);
        this._createdDeleteButton = true;
    }

    protected void removeUnusedDynamicProperties(MaltegoPartSpec maltegoPartSpec) {
        Set<DisplayDescriptor> set = _dynamicProperties.get(maltegoPartSpec);
        if (set == null) {
            return;
        }
        Iterator<DisplayDescriptor> iterator = set.iterator();
        while (iterator.hasNext()) {
            DisplayDescriptor displayDescriptor = iterator.next();
            if (this.isMapped(this._tabularGraph, maltegoPartSpec, (PropertyDescriptor)displayDescriptor)) continue;
            iterator.remove();
        }
    }

    protected class MapListener
    implements PropertyChangeListener {
        protected MapListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("mappingChanged".equals(propertyChangeEvent.getPropertyName())) {
                PropertyTableModel.this.fireTableDataChanged();
            }
        }
    }

    protected class TabularGraphListener
    implements PropertyChangeListener {
        protected TabularGraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("columnNamesChanged".equals(propertyChangeEvent.getPropertyName())) {
                PropertyTableModel.this.fireTableDataChanged();
            } else if ("columnRemoved".equals(propertyChangeEvent.getPropertyName())) {
                PropertyTableModel.this.fireTableDataChanged();
            }
        }
    }
}

