/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.wizard.SampleHeader;
import com.paterva.maltego.graph.table.io.wizard.SampleTableModel;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.JTable;
import org.openide.util.ImageUtilities;

public class LinkSampleTableModel
extends SampleTableModel {
    @Override
    protected Object getHeaderValue(int n) {
        TabularGraphLink tabularGraphLink = TabularGraphUtils.getLink(this.getTabularGraph(), n);
        String string = this.getTabularGraph().getColumnNames()[n];
        Object object = null;
        if (tabularGraphLink != null) {
            PropertyDescriptor propertyDescriptor = tabularGraphLink.getProperty(n);
            Image image = MaltegoLinkSpec.getManualSpec().getIcon(32);
            String string2 = this.createHTMLHeader(string, propertyDescriptor != null ? propertyDescriptor.getDisplayName() : "");
            object = new SampleHeader(ImageUtilities.image2Icon((Image)image), string2, tabularGraphLink.getIndex());
        } else {
            object = this.createHTMLHeader(string, "Unmapped");
        }
        return object;
    }

    @Override
    protected void onColumnSelected(int n) {
        JTable jTable;
        TabularGraphLink tabularGraphLink = TabularGraphUtils.getLink(this.getTabularGraph(), n);
        if (tabularGraphLink != null && (jTable = this.getTable()) instanceof SampleTableModel.CustomizedSelectionTable) {
            SampleTableModel.CustomizedSelectionTable customizedSelectionTable = (SampleTableModel.CustomizedSelectionTable)((Object)jTable);
            customizedSelectionTable.select(tabularGraphLink.getColumns());
        }
    }

    @Override
    protected void onColumnToggled(int[] nArray, int n, boolean bl) {
        List<TabularGraphLink> list = TabularGraphUtils.getLinks(this.getTabularGraph(), nArray);
        if (list.size() == 1) {
            TabularGraphLink tabularGraphLink = list.get(0);
            if (bl) {
                TabularGraphLink tabularGraphLink2 = TabularGraphUtils.getLink(this.getTabularGraph(), n);
                if (tabularGraphLink2 == null) {
                    PropertyDescriptor propertyDescriptor = TabularGraphUtils.getNextUnusedProperty(tabularGraphLink);
                    tabularGraphLink.put(n, propertyDescriptor);
                }
            } else {
                tabularGraphLink.remove(n);
            }
            this.updateTableHeaders();
        }
    }

    @Override
    protected void onTabularGraphChanged(PropertyChangeEvent propertyChangeEvent) {
        super.onTabularGraphChanged(propertyChangeEvent);
        if (this.isUpdatingTabularGraph()) {
            return;
        }
        if ("linkAdded".equals(propertyChangeEvent.getPropertyName()) || "linkRemoved".equals(propertyChangeEvent.getPropertyName()) || "linkUpdated".equals(propertyChangeEvent.getPropertyName()) || "columnNamesChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.updateTableHeaders();
        }
    }
}

