/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.wizard.LinkPropertyTableModel;
import com.paterva.maltego.graph.table.io.wizard.LinkSampleTableModel;
import com.paterva.maltego.graph.table.io.wizard.MappingPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LinkMappingPanel
extends MappingPanel {
    private static final String HINT_UNMAPPED = "To create a link: Select multiple \"Unmapped\" columns that should be mapped to a link and then select the link from the \"Map to\" list.";
    private static final String HINT_MAPPED_ONE = "To modify a link: To add or remove a column from the selected link hold down <Ctrl> and click on the column. To change the property mapping change the appropriate value in the \"Property\" column above.";
    private static final String HINT_MAPPED_MANY = "To unmap columns: Click the \"Unmap column(s)\" button to unmap the selected columns.";

    public LinkMappingPanel() {
        super(new LinkSampleTableModel(), new LinkPropertyTableModel());
    }

    @Override
    protected List getMappableItems() {
        ArrayList<TabularGraphLink> arrayList = new ArrayList<TabularGraphLink>(this.getTabularGraph().getLinks());
        Collections.sort(arrayList, new Comparator<TabularGraphLink>(){

            @Override
            public int compare(TabularGraphLink tabularGraphLink, TabularGraphLink tabularGraphLink2) {
                return tabularGraphLink.toString().compareToIgnoreCase(tabularGraphLink2.toString());
            }
        });
        return arrayList;
    }

    @Override
    protected Object getItem(int n) {
        return TabularGraphUtils.getLink(this.getTabularGraph(), n);
    }

    @Override
    protected List getItems(int[] nArray) {
        List<TabularGraphLink> list = TabularGraphUtils.getLinks(this.getTabularGraph(), nArray);
        return list;
    }

    @Override
    protected Object getMappedItem(Object object) {
        return object;
    }

    @Override
    protected void onComboChanged(Object object) {
        int[] nArray = this.getSelectedColumns();
        TabularGraphLink tabularGraphLink = (TabularGraphLink)object;
        this.getTabularGraph().addColumns(tabularGraphLink, nArray);
    }

    @Override
    protected String getHint(int n) {
        switch (n) {
            case 0: {
                return HINT_UNMAPPED;
            }
            case 1: {
                return HINT_MAPPED_ONE;
            }
            case 2: {
                return HINT_MAPPED_MANY;
            }
        }
        return "";
    }
}

