/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.wizard.EntityPropertyTableModel;
import com.paterva.maltego.graph.table.io.wizard.EntitySampleTableModel;
import com.paterva.maltego.graph.table.io.wizard.MappingPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EntityMappingPanel
extends MappingPanel {
    private static final String HINT_UNMAPPED = "To create an entity: Select multiple \"Unmapped\" columns that should be mapped to an entity and then select the type of the entity from the \"Map to\" list.";
    private static final String HINT_MAPPED_ONE = "To modify an entity: To add or remove a column from the selected entity hold down <Ctrl> and click on the column. To change the property mapping change the appropriate value in the \"Property\" column above.";
    private static final String HINT_MAPPED_MANY = "To unmap columns: Click the \"Unmap column(s)\" button to unmap the selected columns.";

    public EntityMappingPanel() {
        super(new EntitySampleTableModel(), new EntityPropertyTableModel());
    }

    @Override
    protected List getMappableItems() {
        ArrayList arrayList = new ArrayList(EntityRegistry.getDefault().getAllVisible());
        Collections.sort(arrayList, new Comparator<MaltegoEntitySpec>(){

            @Override
            public int compare(MaltegoEntitySpec maltegoEntitySpec, MaltegoEntitySpec maltegoEntitySpec2) {
                return maltegoEntitySpec.getDisplayName().compareToIgnoreCase(maltegoEntitySpec2.getDisplayName());
            }
        });
        return arrayList;
    }

    @Override
    protected Object getItem(int n) {
        return TabularGraphUtils.getEntity(this.getTabularGraph(), n);
    }

    @Override
    protected List getItems(int[] nArray) {
        List<TabularGraphEntity> list = TabularGraphUtils.getEntities(this.getTabularGraph(), nArray);
        return list;
    }

    @Override
    protected Object getMappedItem(Object object) {
        return ((TabularGraphEntity)object).getEntitySpec();
    }

    @Override
    protected void onComboChanged(Object object) {
        int[] nArray = this.getSelectedColumns();
        this.getTabularGraph().putEntity((MaltegoEntitySpec)object, nArray);
    }

    @Override
    protected String getHint(int n) {
        switch (n) {
            case 0: {
                return HINT_UNMAPPED;
            }
            case 1: {
                return HINT_MAPPED_ONE;
            }
            case 2: {
                return HINT_MAPPED_MANY;
            }
        }
        return "";
    }
}

