/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.impl;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.io.TabularGraphDataProvider;
import com.paterva.maltego.graph.table.io.api.TabularGraph;
import com.paterva.maltego.graph.table.io.api.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.api.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultTabularGraph
extends TabularGraph {
    private TabularGraphDataProvider _dataProvider;
    private ArrayList<TabularGraphEntity> _entities;
    private ArrayList<TabularGraphLink> _links;
    private int _columnCount = 0;
    private String[] _columnNames = null;
    private EntityListener _entityListener;
    private boolean _hasHeaderRow;

    public DefaultTabularGraph(TabularGraphDataProvider tabularGraphDataProvider) {
        this._dataProvider = tabularGraphDataProvider;
        this._entities = new ArrayList();
        this._links = new ArrayList();
        this._entityListener = new EntityListener();
    }

    @Override
    public TabularGraphDataProvider getDataProvider() {
        return this._dataProvider;
    }

    @Override
    public List<TabularGraphEntity> getEntities() {
        return Collections.unmodifiableList(this._entities);
    }

    @Override
    public List<TabularGraphLink> getLinks() {
        return Collections.unmodifiableList(this._links);
    }

    @Override
    public void putEntity(MaltegoEntitySpec maltegoEntitySpec, int ... nArray) {
        this.remove(nArray);
        DefaultTabularGraphEntity defaultTabularGraphEntity = new DefaultTabularGraphEntity(maltegoEntitySpec);
        for (int n : nArray) {
            defaultTabularGraphEntity.put(n, TabularGraphUtils.getNextUnusedProperty(defaultTabularGraphEntity));
            this.firePropertyChanged("columnAdded", null, n);
        }
        this._entities.add(defaultTabularGraphEntity);
        defaultTabularGraphEntity.addPropertyChangeListener(this._entityListener);
        this.firePropertyChanged("entityAdded", null, defaultTabularGraphEntity);
    }

    @Override
    public void putLink(TabularGraphLink tabularGraphLink) {
        this._links.add(tabularGraphLink);
        this.firePropertyChanged("linkAdded", null, tabularGraphLink);
    }

    public TabularGraphLink getLink(String string) {
        for (TabularGraphLink tabularGraphLink : this._links) {
            if (!string.equals(tabularGraphLink.getIndex())) continue;
            return tabularGraphLink;
        }
        return null;
    }

    @Override
    public void addColumns(TabularGraphLink tabularGraphLink, int ... nArray) {
        boolean bl = false;
        for (TabularGraphLink tabularGraphLink2 : this._links) {
            if (tabularGraphLink.equals(tabularGraphLink2)) continue;
            tabularGraphLink2.remove(nArray);
            bl = true;
        }
        for (Object object : (Object)nArray) {
            if (tabularGraphLink.contains((int)object)) continue;
            PropertyDescriptor propertyDescriptor = TabularGraphUtils.getNextUnusedProperty(tabularGraphLink);
            tabularGraphLink.put((int)object, propertyDescriptor);
            bl = true;
        }
        if (bl) {
            this.firePropertyChanged("linkUpdated", null, tabularGraphLink);
        }
    }

    @Override
    public void removeLink(TabularGraphLink tabularGraphLink) {
        this._links.remove(tabularGraphLink);
        this.firePropertyChanged("linkRemoved", tabularGraphLink, null);
    }

    @Override
    public void remove(int ... nArray) {
        for (int n : nArray) {
            TabularGraphEntity tabularGraphEntity = TabularGraphUtils.getEntity(this, n);
            if (tabularGraphEntity == null) continue;
            tabularGraphEntity.remove(n);
            this.firePropertyChanged("columnRemoved", new Object[]{tabularGraphEntity, n}, null);
            if (tabularGraphEntity.getColumnCount() == 0) {
                this._entities.remove(tabularGraphEntity);
                Iterator<TabularGraphLink> iterator = this._links.iterator();
                while (iterator.hasNext()) {
                    TabularGraphLink tabularGraphLink = iterator.next();
                    if (!tabularGraphLink.getSource().equals(tabularGraphEntity) && !tabularGraphLink.getTarget().equals(tabularGraphEntity)) continue;
                    iterator.remove();
                }
                tabularGraphEntity.removePropertyChangeListener(this._entityListener);
                this.firePropertyChanged("entityRemoved", tabularGraphEntity, null);
                continue;
            }
            this.firePropertyChanged("entityUpdated", null, tabularGraphEntity);
        }
    }

    @Override
    public int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public void setColumnCount(int n) {
        this._columnCount = n;
    }

    @Override
    public String[] getColumnNames() {
        return this._columnNames;
    }

    @Override
    public void setColumnNames(String[] stringArray) {
        if (stringArray.length != this._columnCount) {
            throw new IllegalArgumentException();
        }
        this._columnNames = stringArray;
        this.firePropertyChanged("columnNamesChanged", null, this._columnNames);
    }

    @Override
    public boolean hasHeaderRow() {
        return this._hasHeaderRow;
    }

    @Override
    public void setHasHeaderRow(boolean bl) {
        this._hasHeaderRow = bl;
        this.firePropertyChanged("hasHeaderRowChanged", null, null);
    }

    private class EntityListener
    implements PropertyChangeListener {
        private EntityListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("mappingChanged".equals(propertyChangeEvent.getPropertyName())) {
                DefaultTabularGraph.this.firePropertyChanged("entityUpdated", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

