/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.option;

import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.wizard.im.ImportWizard;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class ImportOptionProcessor
extends OptionProcessor {
    private static final Option IMPORT = Option.requiredArgument((char)'i', (String)"import");

    protected Set<Option> getOptions() {
        return Collections.singleton(IMPORT);
    }

    protected void process(Env env, final Map<Option, String[]> map) throws CommandException {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ImportOptionProcessor.importFile(ImportOptionProcessor.getFile((String[])map.get(IMPORT)));
            }
        });
    }

    private static void importFile(File file) {
        if (file != null) {
            ConfigImporter[] configImporterArray = ConfigImporter.getAll(Lookup.getDefault());
            if (configImporterArray.length == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The chosen import operation is not available in this version of Maltego."));
            } else {
                WizardUtilities.runWizard((WizardDescriptor)ImportWizard.create(configImporterArray, file));
            }
        }
    }

    private static File getFile(String[] stringArray) {
        File file;
        if (stringArray != null && stringArray.length > 0 && (file = new File(stringArray[0])).exists()) {
            return file;
        }
        return null;
    }
}

