/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileReader;
import com.paterva.maltego.java.config.ConfigFileWriter;
import com.paterva.maltego.java.config.ConfigOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JavaOptionsPanel
extends JPanel {
    protected JTextField _maxHeapSize;
    protected JLabel _errorLabel;

    public JavaOptionsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JLabel label1 = new JLabel("Max Memory");
        JLabel label2 = new JLabel("MB");
        JTextArea disclaimer = new JTextArea("Warning: Changing the maximum memory allocated to Maltego is for advanced users only. It is possible that Maltego will not start up if this value is set too high. The change will be applied the next time Maltego is run.");
        disclaimer.setLineWrap(true);
        disclaimer.setWrapStyleWord(true);
        disclaimer.setBackground(label1.getBackground());
        this._errorLabel = new JLabel("");
        this._errorLabel.setForeground(Color.red);
        this._maxHeapSize = new JTextField("0", 6);
        this._maxHeapSize.setHorizontalAlignment(4);
        this._maxHeapSize.setMaximumSize(new Dimension(100, this._maxHeapSize.getPreferredSize().height));
        JPanel disclaimerPanel = new JPanel(new BorderLayout());
        disclaimerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        disclaimerPanel.add(disclaimer);
        disclaimerPanel.setAlignmentX(0.0f);
        JPanel maxMemPanel = new JPanel();
        maxMemPanel.setAlignmentX(0.0f);
        maxMemPanel.setLayout(new BoxLayout(maxMemPanel, 0));
        maxMemPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        maxMemPanel.add(label1);
        maxMemPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        maxMemPanel.add(this._maxHeapSize);
        maxMemPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        maxMemPanel.add(label2);
        maxMemPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        maxMemPanel.add(this._errorLabel);
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new BoxLayout(groupPanel, 1));
        groupPanel.setBorder(BorderFactory.createTitledBorder("Memory"));
        groupPanel.add(disclaimerPanel);
        groupPanel.add(maxMemPanel);
        this.add((Component)groupPanel, "North");
    }

    public void load() {
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        System.out.println("Runtime max memory: " + maxMemory + "MB");
        ConfigFileReader configFile = new ConfigFileReader();
        ConfigOptions options = configFile.read();
        System.out.println("Config file max memory: " + options.getMaxHeapSize() + "MB");
        if (options.getMaxHeapSize() == null) {
            options.setMaxHeapSize(1024L);
        }
        this._maxHeapSize.setText(options.getMaxHeapSize().toString());
    }

    public void store() {
        ConfigOptions options = new ConfigOptions();
        try {
            long maxHeapSize = Long.parseLong(this._maxHeapSize.getText());
            options.setMaxHeapSize(maxHeapSize);
            ConfigFileWriter configFile = new ConfigFileWriter();
            configFile.write(options);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean valid() {
        try {
            long maxHeapSize = Long.parseLong(this._maxHeapSize.getText());
            if (maxHeapSize < 64L) {
                this._errorLabel.setText("* Must be 64MB or more");
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this._errorLabel.setText("* Must be numeric");
            return false;
        }
        this._errorLabel.setText("");
        return true;
    }
}

