/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.PersistenceMode;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transform.repository.serializer.PopupTranslator;
import com.paterva.maltego.transform.repository.serializer.VisibilityTranslator;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

public class TransformSettingsSerializer {
    public TransformSettings read(InputStream inputStream) throws XmlSerializationException {
        XmlSerializer xmlSerializer = new XmlSerializer();
        SettingsStub settingsStub = (SettingsStub)xmlSerializer.read(SettingsStub.class, inputStream);
        return TransformSettingsSerializer.translate(settingsStub);
    }

    public void write(TransformDefinition transformDefinition, OutputStream outputStream, boolean bl) throws XmlSerializationException {
        XmlSerializer xmlSerializer = new XmlSerializer();
        SettingsStub settingsStub = TransformSettingsSerializer.translate((TransformSettings)transformDefinition, (Iterable<DisplayDescriptor>)transformDefinition.getProperties(), bl);
        xmlSerializer.write((Object)settingsStub, outputStream);
    }

    public static TransformSettings translate(SettingsStub settingsStub) {
        ListMapTransformSettings listMapTransformSettings = new ListMapTransformSettings();
        listMapTransformSettings.setEnabled(settingsStub.isEnabled());
        listMapTransformSettings.setDisclaimerAccepted(settingsStub.isDisclaimerAccepted());
        listMapTransformSettings.setShowHelp(settingsStub.isShowHelp());
        for (PropertyStub propertyStub : settingsStub.getProperties()) {
            Object object = Converter.convertFrom((String)propertyStub.getValue(), (String)propertyStub.getType());
            listMapTransformSettings.setValue(propertyStub.getName(), object);
            listMapTransformSettings.setPopup(propertyStub.getName(), PopupTranslator.get(propertyStub.isPopup()));
            listMapTransformSettings.setVisibility(propertyStub.getName(), VisibilityTranslator.get(propertyStub.getVisibility()));
        }
        listMapTransformSettings.markClean();
        return listMapTransformSettings;
    }

    public static SettingsStub translate(TransformSettings transformSettings, Iterable<DisplayDescriptor> iterable, boolean bl) {
        SettingsStub settingsStub = new SettingsStub();
        settingsStub.setEnabled(transformSettings.isEnabled());
        settingsStub.setDisclaimerAccepted(transformSettings.isDisclaimerAccepted());
        settingsStub.setShowHelp(transformSettings.showHelp());
        for (DisplayDescriptor displayDescriptor : iterable) {
            Object object;
            Object object2;
            boolean bl2 = TransformSettingsSerializer.shouldPersistValue(displayDescriptor, bl);
            PropertyStub propertyStub = new PropertyStub(displayDescriptor.getName(), displayDescriptor.getTypeDescriptor().getTypeName());
            Object object3 = object2 = bl2 ? transformSettings.getValue((PropertyDescriptor)displayDescriptor) : null;
            if (object2 != null && !object2.equals(displayDescriptor.getDefaultValue())) {
                object = displayDescriptor.getTypeDescriptor().convert(object2);
                propertyStub.setValue((String)object);
            }
            object = transformSettings.getPopup((PropertyDescriptor)displayDescriptor);
            boolean bl3 = bl2 ? PopupTranslator.get(object) : true;
            propertyStub.setPopup(bl3);
            Visibility visibility = transformSettings.getVisibility((PropertyDescriptor)displayDescriptor);
            if (visibility != Visibility.Public) {
                String string = VisibilityTranslator.get(visibility);
                propertyStub.setVisibility(string);
            }
            settingsStub.getProperties().add(propertyStub);
        }
        return settingsStub;
    }

    private static boolean shouldPersistValue(DisplayDescriptor displayDescriptor, boolean bl) {
        boolean bl2 = true;
        if (displayDescriptor instanceof TransformPropertyDescriptor) {
            TransformPropertyDescriptor transformPropertyDescriptor = (TransformPropertyDescriptor)displayDescriptor;
            PersistenceMode persistenceMode = transformPropertyDescriptor.getPersistence();
            switch (persistenceMode) {
                case None: {
                    bl2 = false;
                    break;
                }
                case NoExport: {
                    bl2 = !bl;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    @Root(name="Property")
    public static class PropertyStub {
        @Attribute(name="name")
        private String _name;
        @Attribute(name="type")
        private String _type;
        @Attribute(name="popup", required=false)
        private boolean _popup;
        @Attribute(name="persistence", required=false)
        private String _persistence;
        @Attribute(name="visibility", required=false)
        private String _visibility;
        @Text(required=false)
        private String _value;

        public PropertyStub() {
            this(null, null);
        }

        public PropertyStub(String string, String string2) {
            this._name = string;
            this._type = string2;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String string) {
            this._name = string;
        }

        public boolean isPopup() {
            return this._popup;
        }

        public void setPopup(boolean bl) {
            this._popup = bl;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getPersistence() {
            return this._persistence;
        }

        public void setPersistence(String string) {
            this._persistence = string;
        }

        public String getVisibility() {
            return this._visibility;
        }

        public void setVisibility(String string) {
            this._visibility = string;
        }
    }

    @Root(name="TransformSettings")
    public static class SettingsStub {
        @Attribute(name="enabled", required=false)
        private boolean _enabled = true;
        @Attribute(name="disclaimerAccepted", required=false)
        private boolean _disclaimerAccepted = false;
        @Attribute(name="showHelp", required=false)
        private boolean _showHelp = false;
        @ElementList(name="Properties", type=PropertyStub.class, required=false)
        private List<PropertyStub> _fields;

        public SettingsStub() {
        }

        public SettingsStub(List<PropertyStub> list) {
            this._fields = list;
        }

        public List<PropertyStub> getProperties() {
            if (this._fields == null) {
                this._fields = new LinkedList<PropertyStub>();
            }
            return this._fields;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean bl) {
            this._enabled = bl;
        }

        public boolean isDisclaimerAccepted() {
            return this._disclaimerAccepted;
        }

        public void setDisclaimerAccepted(boolean bl) {
            this._disclaimerAccepted = bl;
        }

        public boolean isShowHelp() {
            return this._showHelp;
        }

        public void setShowHelp(boolean bl) {
            this._showHelp = bl;
        }
    }
}

