/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transform.repository.TransformDefinitionCookie;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FSTransformRepository
extends TransformRepository {
    private String _name;
    private FileObject _folder;
    private Set<TransformDefinition> _transforms;
    private static final String TRANSFORM_EXT = "transform";
    private static final String SETTINGS_EXT = "transformsettings";

    public FSTransformRepository(String string, FileObject fileObject) {
        this._folder = fileObject;
        this._name = string;
    }

    private Set<TransformDefinition> transforms() {
        if (this._transforms == null) {
            this._transforms = new HashSet<TransformDefinition>();
            for (FileObject fileObject : this._folder.getChildren()) {
                TransformDefinition transformDefinition;
                if (fileObject.isFolder() || (transformDefinition = this.get(fileObject)) == null) continue;
                this._transforms.add(transformDefinition);
            }
        }
        return this._transforms;
    }

    public Set<TransformDefinition> getAll() {
        return Collections.unmodifiableSet(this.transforms());
    }

    public TransformDefinition get(String string) {
        for (TransformDefinition transformDefinition : this.transforms()) {
            if (!transformDefinition.getName().equals(string)) continue;
            return transformDefinition;
        }
        return null;
    }

    private TransformDefinition get(FileObject fileObject) {
        if (fileObject != null) {
            try {
                TransformDefinitionCookie transformDefinitionCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject != null && (transformDefinitionCookie = (TransformDefinitionCookie)dataObject.getLookup().lookup(TransformDefinitionCookie.class)) != null) {
                    TransformDefinition transformDefinition = transformDefinitionCookie.getTransformDefinition();
                    transformDefinition.setRepositoryName(this._name);
                    transformDefinition.markClean();
                    return transformDefinition;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return null;
    }

    public Set<TransformDefinition> find(TransformFilter transformFilter) {
        HashSet<TransformDefinition> hashSet = new HashSet<TransformDefinition>();
        this.find(transformFilter, hashSet);
        return hashSet;
    }

    void find(TransformFilter transformFilter, Set<TransformDefinition> set) {
        for (TransformDefinition transformDefinition : this.transforms()) {
            if (!transformFilter.matches(transformDefinition)) continue;
            set.add(transformDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TransformDescriptor transformDescriptor) {
        OutputStream outputStream = null;
        try {
            TransformDefinition transformDefinition;
            TransformDefinition transformDefinition2;
            Object object;
            FileObject fileObject = this._folder.getFileObject(transformDescriptor.getName(), TRANSFORM_EXT);
            try {
                if (fileObject == null) {
                    fileObject = this._folder.createData(transformDescriptor.getName(), TRANSFORM_EXT);
                }
                outputStream = fileObject.getOutputStream();
                object = new TransformDescriptorSerializer();
                ((TransformDescriptorSerializer)object).write(transformDescriptor, outputStream);
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            object = this.get(fileObject);
            if (object == null) {
                object = new ListMapTransformSettings();
            }
            if ((transformDefinition2 = this.get((transformDefinition = new TransformDefinition(transformDescriptor, (TransformSettings)object)).getName())) != null) {
                this.transforms().remove(transformDefinition2);
                this.fireItemRemoved(transformDefinition2);
            }
            transformDefinition.setRepositoryName(this._name);
            transformDefinition.markClean();
            this.transforms().add(transformDefinition);
            this.fireItemAdded(transformDefinition);
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            Exceptions.printStackTrace((Throwable)fileAlreadyLockedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings(TransformDefinition transformDefinition) {
        if (transformDefinition.isDirty() && this.get(transformDefinition.getName()) != null) {
            OutputStream outputStream = null;
            try {
                FileObject fileObject = this._folder.getFileObject(transformDefinition.getName(), SETTINGS_EXT);
                if (fileObject == null) {
                    fileObject = this._folder.createData(transformDefinition.getName(), SETTINGS_EXT);
                }
                outputStream = fileObject.getOutputStream();
                TransformSettingsSerializer transformSettingsSerializer = new TransformSettingsSerializer();
                transformSettingsSerializer.write(transformDefinition, outputStream, false);
                transformDefinition.markClean();
                this.fireItemChanged(transformDefinition);
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                Exceptions.printStackTrace((Throwable)fileAlreadyLockedException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    public boolean remove(String string) {
        boolean bl = false;
        FileObject fileObject = this._folder.getFileObject(string, TRANSFORM_EXT);
        FileObject fileObject2 = this._folder.getFileObject(string, SETTINGS_EXT);
        if (fileObject != null) {
            try {
                fileObject.delete();
                bl = true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject2 != null) {
            try {
                fileObject2.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        TransformDefinition transformDefinition = this.get(string);
        this.transforms().remove(transformDefinition);
        this.fireItemRemoved(transformDefinition);
        return bl;
    }
}

