/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class StyleSheetAggregator {
    private final HTMLDocumentImpl document;
    private final Map classMapsByElement = new HashMap();
    private final Map idMapsByElement = new HashMap();
    private final Map rulesByElement = new HashMap();

    public StyleSheetAggregator(HTMLDocumentImpl document) {
        this.document = document;
    }

    public final void addStyleSheets(Collection styleSheets) throws MalformedURLException {
        for (CSSStyleSheet sheet : styleSheets) {
            this.addStyleSheet(sheet);
        }
    }

    private final void addStyleSheet(CSSStyleSheet styleSheet) throws MalformedURLException {
        CSSRuleList ruleList = styleSheet.getCssRules();
        int length = ruleList.getLength();
        for (int i = 0; i < length; ++i) {
            CSSRule rule = ruleList.item(i);
            this.addRule(styleSheet, rule);
        }
    }

    private final void addRule(CSSStyleSheet styleSheet, CSSRule rule) throws MalformedURLException {
        block11: {
            CSSMediaRule mrule;
            MediaList mediaList;
            HTMLDocumentImpl document;
            block12: {
                CSSImportRule importRule;
                block10: {
                    document = this.document;
                    if (!(rule instanceof CSSStyleRule)) break block10;
                    CSSStyleRule sr = (CSSStyleRule)rule;
                    String selectorList = sr.getSelectorText();
                    StringTokenizer commaTok = new StringTokenizer(selectorList, ",");
                    while (commaTok.hasMoreTokens()) {
                        String selectorPart = commaTok.nextToken().toLowerCase();
                        ArrayList<SimpleSelector> simpleSelectors = null;
                        String lastSelectorText = null;
                        StringTokenizer tok = new StringTokenizer(selectorPart, " \t\r\n");
                        if (tok.hasMoreTokens()) {
                            String simpleSelectorText;
                            simpleSelectors = new ArrayList<SimpleSelector>();
                            SimpleSelector prevSelector = null;
                            while (true) {
                                String token;
                                if (">".equals(token = tok.nextToken())) {
                                    if (prevSelector == null) continue;
                                    prevSelector.setSelectorType(1);
                                    continue;
                                }
                                if ("+".equals(token)) {
                                    if (prevSelector == null) continue;
                                    prevSelector.setSelectorType(2);
                                    continue;
                                }
                                int colonIdx = token.indexOf(58);
                                simpleSelectorText = colonIdx == -1 ? token : token.substring(0, colonIdx);
                                String pseudoElement = colonIdx == -1 ? null : token.substring(colonIdx + 1);
                                prevSelector = new SimpleSelector(simpleSelectorText, pseudoElement);
                                simpleSelectors.add(prevSelector);
                                if (!tok.hasMoreTokens()) break;
                            }
                            lastSelectorText = simpleSelectorText;
                        }
                        if (lastSelectorText == null) continue;
                        int dotIdx = lastSelectorText.indexOf(46);
                        if (dotIdx != -1) {
                            String elemtl = lastSelectorText.substring(0, dotIdx);
                            String classtl = lastSelectorText.substring(dotIdx + 1);
                            this.addClassRule(elemtl, classtl, sr, simpleSelectors);
                            continue;
                        }
                        int poundIdx = lastSelectorText.indexOf(35);
                        if (poundIdx != -1) {
                            String elemtl = lastSelectorText.substring(0, poundIdx);
                            String idtl = lastSelectorText.substring(poundIdx + 1);
                            this.addIdRule(elemtl, idtl, sr, simpleSelectors);
                            continue;
                        }
                        String elemtl = lastSelectorText;
                        this.addElementRule(elemtl, sr, simpleSelectors);
                    }
                    break block11;
                }
                if (!(rule instanceof CSSImportRule)) break block12;
                UserAgentContext uacontext = document.getUserAgentContext();
                if (!uacontext.isExternalCSSEnabled() || !CSSUtilities.matchesMedia((importRule = (CSSImportRule)rule).getMedia(), uacontext)) break block11;
                String href = importRule.getHref();
                String styleHref = styleSheet.getHref();
                String baseHref = styleHref == null ? document.getBaseURI() : styleHref;
                CSSStyleSheet sheet = CSSUtilities.parse(styleSheet.getOwnerNode(), href, document, baseHref, false);
                if (sheet != null) {
                    this.addStyleSheet(sheet);
                }
                break block11;
            }
            if (rule instanceof CSSMediaRule && CSSUtilities.matchesMedia(mediaList = (mrule = (CSSMediaRule)rule).getMedia(), document.getUserAgentContext())) {
                CSSRuleList ruleList = mrule.getCssRules();
                int length = ruleList.getLength();
                for (int i = 0; i < length; ++i) {
                    CSSRule subRule = ruleList.item(i);
                    this.addRule(styleSheet, subRule);
                }
            }
        }
    }

    private final void addClassRule(String elemtl, String classtl, CSSStyleRule styleRule, ArrayList ancestorSelectors) {
        LinkedList<StyleRuleInfo> rules;
        HashMap<String, LinkedList<StyleRuleInfo>> classMap = (HashMap<String, LinkedList<StyleRuleInfo>>)this.classMapsByElement.get(elemtl);
        if (classMap == null) {
            classMap = new HashMap<String, LinkedList<StyleRuleInfo>>();
            this.classMapsByElement.put(elemtl, classMap);
        }
        if ((rules = (LinkedList<StyleRuleInfo>)classMap.get(classtl)) == null) {
            rules = new LinkedList<StyleRuleInfo>();
            classMap.put(classtl, rules);
        }
        rules.add(new StyleRuleInfo(ancestorSelectors, styleRule));
    }

    private final void addIdRule(String elemtl, String idtl, CSSStyleRule styleRule, ArrayList ancestorSelectors) {
        LinkedList<StyleRuleInfo> rules;
        HashMap<String, LinkedList<StyleRuleInfo>> idsMap = (HashMap<String, LinkedList<StyleRuleInfo>>)this.idMapsByElement.get(elemtl);
        if (idsMap == null) {
            idsMap = new HashMap<String, LinkedList<StyleRuleInfo>>();
            this.idMapsByElement.put(elemtl, idsMap);
        }
        if ((rules = (LinkedList<StyleRuleInfo>)idsMap.get(idtl)) == null) {
            rules = new LinkedList<StyleRuleInfo>();
            idsMap.put(idtl, rules);
        }
        rules.add(new StyleRuleInfo(ancestorSelectors, styleRule));
    }

    private final void addElementRule(String elemtl, CSSStyleRule styleRule, ArrayList ancestorSelectors) {
        LinkedList<StyleRuleInfo> rules = (LinkedList<StyleRuleInfo>)this.rulesByElement.get(elemtl);
        if (rules == null) {
            rules = new LinkedList<StyleRuleInfo>();
            this.rulesByElement.put(elemtl, rules);
        }
        rules.add(new StyleRuleInfo(ancestorSelectors, styleRule));
    }

    public final Collection getActiveStyleDeclarations(HTMLElementImpl element, String elementName, String elementId, String className, Set pseudoNames) {
        CSSStyleRule styleRule;
        CSSStyleSheet styleSheet;
        CSSStyleRule styleRule2;
        CSSStyleSheet styleSheet2;
        LinkedList<CSSStyleDeclaration> styleDeclarations = null;
        String elementTL = elementName.toLowerCase();
        Collection elementRules = (Collection)this.rulesByElement.get(elementTL);
        if (elementRules != null) {
            for (StyleRuleInfo styleRuleInfo : elementRules) {
                if (!styleRuleInfo.isSelectorMatch(element, pseudoNames) || (styleSheet2 = (styleRule2 = styleRuleInfo.styleRule).getParentStyleSheet()) != null && styleSheet2.getDisabled()) continue;
                if (styleDeclarations == null) {
                    styleDeclarations = new LinkedList<CSSStyleDeclaration>();
                }
                styleDeclarations.add(styleRule2.getStyle());
            }
        }
        if ((elementRules = (Collection)this.rulesByElement.get("*")) != null) {
            for (StyleRuleInfo styleRuleInfo : elementRules) {
                if (!styleRuleInfo.isSelectorMatch(element, pseudoNames) || (styleSheet2 = (styleRule2 = styleRuleInfo.styleRule).getParentStyleSheet()) != null && styleSheet2.getDisabled()) continue;
                if (styleDeclarations == null) {
                    styleDeclarations = new LinkedList();
                }
                styleDeclarations.add(styleRule2.getStyle());
            }
        }
        if (className != null) {
            Collection classRules;
            String classNameTL = className.toLowerCase();
            Map classMaps = (Map)this.classMapsByElement.get(elementTL);
            if (classMaps != null && (classRules = (Collection)classMaps.get(classNameTL)) != null) {
                for (StyleRuleInfo styleRuleInfo : classRules) {
                    if (!styleRuleInfo.isSelectorMatch(element, pseudoNames) || (styleSheet = (styleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && styleSheet.getDisabled()) continue;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
            if ((classMaps = (Map)this.classMapsByElement.get("*")) != null && (classRules = (Collection)classMaps.get(classNameTL)) != null) {
                for (StyleRuleInfo styleRuleInfo : classRules) {
                    if (!styleRuleInfo.isSelectorMatch(element, pseudoNames) || (styleSheet = (styleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && styleSheet.getDisabled()) continue;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
        }
        if (elementId != null) {
            String elementIdTL;
            Collection idRules;
            Map idMaps = (Map)this.idMapsByElement.get(elementTL);
            if (idMaps != null && (idRules = (Collection)idMaps.get(elementIdTL = elementId.toLowerCase())) != null) {
                for (StyleRuleInfo styleRuleInfo : idRules) {
                    if (!styleRuleInfo.isSelectorMatch(element, pseudoNames) || (styleSheet = (styleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && styleSheet.getDisabled()) continue;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
            if ((idMaps = (Map)this.idMapsByElement.get("*")) != null && (idRules = (Collection)idMaps.get(elementIdTL = elementId.toLowerCase())) != null) {
                for (StyleRuleInfo styleRuleInfo : idRules) {
                    if (!styleRuleInfo.isSelectorMatch(element, pseudoNames) || (styleSheet = (styleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && styleSheet.getDisabled()) continue;
                    if (styleDeclarations == null) {
                        styleDeclarations = new LinkedList();
                    }
                    styleDeclarations.add(styleRule.getStyle());
                }
            }
        }
        return styleDeclarations;
    }

    public final boolean affectedByPseudoNameInAncestor(HTMLElementImpl element, HTMLElementImpl ancestor, String elementName, String elementId, String[] classArray, String pseudoName) {
        CSSStyleSheet styleSheet;
        String elementTL = elementName.toLowerCase();
        Collection elementRules = (Collection)this.rulesByElement.get(elementTL);
        if (elementRules != null) {
            for (StyleRuleInfo styleRuleInfo : elementRules) {
                styleSheet = styleRuleInfo.styleRule.getParentStyleSheet();
                if (styleSheet != null && styleSheet.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(element, ancestor, pseudoName)) continue;
                return true;
            }
        }
        if ((elementRules = (Collection)this.rulesByElement.get("*")) != null) {
            for (StyleRuleInfo styleRuleInfo : elementRules) {
                styleSheet = styleRuleInfo.styleRule.getParentStyleSheet();
                if (styleSheet != null && styleSheet.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(element, ancestor, pseudoName)) continue;
                return true;
            }
        }
        if (classArray != null) {
            for (int cidx = 0; cidx < classArray.length; ++cidx) {
                CSSStyleSheet styleSheet2;
                Collection classRules;
                String className = classArray[cidx];
                String classNameTL = className.toLowerCase();
                Map classMaps = (Map)this.classMapsByElement.get(elementTL);
                if (classMaps != null && (classRules = (Collection)classMaps.get(classNameTL)) != null) {
                    for (StyleRuleInfo styleRuleInfo : classRules) {
                        styleSheet2 = styleRuleInfo.styleRule.getParentStyleSheet();
                        if (styleSheet2 != null && styleSheet2.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(element, ancestor, pseudoName)) continue;
                        return true;
                    }
                }
                if ((classMaps = (Map)this.classMapsByElement.get("*")) == null || (classRules = (Collection)classMaps.get(classNameTL)) == null) continue;
                for (StyleRuleInfo styleRuleInfo : classRules) {
                    styleSheet2 = styleRuleInfo.styleRule.getParentStyleSheet();
                    if (styleSheet2 != null && styleSheet2.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(element, ancestor, pseudoName)) continue;
                    return true;
                }
            }
        }
        if (elementId != null) {
            CSSStyleSheet styleSheet3;
            String elementIdTL;
            Collection idRules;
            Map idMaps = (Map)this.idMapsByElement.get(elementTL);
            if (idMaps != null && (idRules = (Collection)idMaps.get(elementIdTL = elementId.toLowerCase())) != null) {
                for (StyleRuleInfo styleRuleInfo : idRules) {
                    styleSheet3 = styleRuleInfo.styleRule.getParentStyleSheet();
                    if (styleSheet3 != null && styleSheet3.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(element, ancestor, pseudoName)) continue;
                    return true;
                }
            }
            if ((idMaps = (Map)this.idMapsByElement.get("*")) != null && (idRules = (Collection)idMaps.get(elementIdTL = elementId.toLowerCase())) != null) {
                for (StyleRuleInfo styleRuleInfo : idRules) {
                    styleSheet3 = styleRuleInfo.styleRule.getParentStyleSheet();
                    if (styleSheet3 != null && styleSheet3.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(element, ancestor, pseudoName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static class SimpleSelector {
        public static final int ANCESTOR = 0;
        public static final int PARENT = 1;
        public static final int PRECEEDING_SIBLING = 2;
        public final String simpleSelectorText;
        public final String pseudoElement;
        public int selectorType;

        public SimpleSelector(String simpleSelectorText, String pseudoElement) {
            this.simpleSelectorText = simpleSelectorText;
            this.pseudoElement = pseudoElement;
            this.selectorType = 0;
        }

        public final boolean matches(HTMLElementImpl element) {
            Set names = element.getPseudoNames();
            if (names == null) {
                return this.pseudoElement == null;
            }
            String pe = this.pseudoElement;
            return pe == null || names.contains(pe);
        }

        public final boolean matches(Set names) {
            if (names == null) {
                return this.pseudoElement == null;
            }
            String pe = this.pseudoElement;
            return pe == null || names.contains(pe);
        }

        public final boolean matches(String pseudoName) {
            if (pseudoName == null) {
                return this.pseudoElement == null;
            }
            String pe = this.pseudoElement;
            return pe == null || pseudoName.equals(pe);
        }

        public final boolean hasPseudoName(String pseudoName) {
            return pseudoName.equals(this.pseudoElement);
        }

        public int getSelectorType() {
            return this.selectorType;
        }

        public void setSelectorType(int selectorType) {
            this.selectorType = selectorType;
        }
    }

    private static class StyleRuleInfo {
        private final CSSStyleRule styleRule;
        private final ArrayList ancestorSelectors;

        public StyleRuleInfo(ArrayList simpleSelectors, CSSStyleRule rule) {
            this.ancestorSelectors = simpleSelectors;
            this.styleRule = rule;
        }

        public final boolean affectedByPseudoNameInAncestor(HTMLElementImpl element, HTMLElementImpl ancestor, String pseudoName) {
            ArrayList as = this.ancestorSelectors;
            HTMLElementImpl currentElement = element;
            int size = as.size();
            boolean first = true;
            int i = size;
            while (--i >= 0) {
                HTMLElementImpl newElement;
                SimpleSelector simpleSelector = (SimpleSelector)as.get(i);
                if (first) {
                    if (ancestor == element) {
                        return simpleSelector.hasPseudoName(pseudoName);
                    }
                    first = false;
                    continue;
                }
                String selectorText = simpleSelector.simpleSelectorText;
                int dotIdx = selectorText.indexOf(46);
                if (dotIdx != -1) {
                    String elemtl = selectorText.substring(0, dotIdx);
                    String classtl = selectorText.substring(dotIdx + 1);
                    newElement = currentElement.getAncestorWithClass(elemtl, classtl);
                } else {
                    String elemtl;
                    int poundIdx = selectorText.indexOf(35);
                    if (poundIdx != -1) {
                        elemtl = selectorText.substring(0, poundIdx);
                        String idtl = selectorText.substring(poundIdx + 1);
                        newElement = currentElement.getAncestorWithId(elemtl, idtl);
                    } else {
                        elemtl = selectorText;
                        newElement = currentElement.getAncestor(elemtl);
                    }
                }
                if (newElement == null) {
                    return false;
                }
                currentElement = newElement;
                if (currentElement != ancestor) continue;
                return simpleSelector.hasPseudoName(pseudoName);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSelectorMatch(HTMLElementImpl element, Set pseudoNames) {
            ArrayList as = this.ancestorSelectors;
            HTMLElementImpl currentElement = element;
            int size = as.size();
            boolean first = true;
            int i = size;
            while (--i >= 0) {
                HTMLElementImpl priorElement;
                SimpleSelector simpleSelector = (SimpleSelector)as.get(i);
                if (first) {
                    if (!simpleSelector.matches(pseudoNames)) {
                        return false;
                    }
                    first = false;
                    continue;
                }
                String selectorText = simpleSelector.simpleSelectorText;
                int dotIdx = selectorText.indexOf(46);
                int selectorType = simpleSelector.selectorType;
                if (dotIdx != -1) {
                    String elemtl = selectorText.substring(0, dotIdx);
                    String classtl = selectorText.substring(dotIdx + 1);
                    if (selectorType == 0) {
                        priorElement = currentElement.getAncestorWithClass(elemtl, classtl);
                    } else if (selectorType == 1) {
                        priorElement = currentElement.getParentWithClass(elemtl, classtl);
                    } else {
                        if (selectorType != 2) throw new IllegalStateException("selectorType=" + selectorType);
                        priorElement = currentElement.getPreceedingSiblingWithClass(elemtl, classtl);
                    }
                } else {
                    String elemtl;
                    int poundIdx = selectorText.indexOf(35);
                    if (poundIdx != -1) {
                        elemtl = selectorText.substring(0, poundIdx);
                        String idtl = selectorText.substring(poundIdx + 1);
                        if (selectorType == 0) {
                            priorElement = currentElement.getAncestorWithId(elemtl, idtl);
                        } else if (selectorType == 1) {
                            priorElement = currentElement.getParentWithId(elemtl, idtl);
                        } else {
                            if (selectorType != 2) throw new IllegalStateException("selectorType=" + selectorType);
                            priorElement = currentElement.getPreceedingSiblingWithId(elemtl, idtl);
                        }
                    } else {
                        elemtl = selectorText;
                        if (selectorType == 0) {
                            priorElement = currentElement.getAncestor(elemtl);
                        } else if (selectorType == 1) {
                            priorElement = currentElement.getParent(elemtl);
                        } else {
                            if (selectorType != 2) throw new IllegalStateException("selectorType=" + selectorType);
                            priorElement = currentElement.getPreceedingSibling(elemtl);
                        }
                    }
                }
                if (priorElement == null) {
                    return false;
                }
                if (!simpleSelector.matches(priorElement)) {
                    return false;
                }
                currentElement = priorElement;
            }
            return true;
        }
    }
}

