/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;
import org.netbeans.modules.editor.lib2.view.OffsetRegion;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewBuilder;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ViewUpdates
implements DocumentListener,
EditorViewFactoryListener {
    private static final Logger LOG = Logger.getLogger(ViewUpdates.class.getName());
    private static final int REBUILD_DELAY = 0;
    private static final int LAZY_CHILDREN_MIN_BATCH_LINES = 5;
    private static final RequestProcessor rebuildRegionRP = new RequestProcessor("ViewHierarchy-Region-Rebuilding", 1, false, false);
    private static boolean directViewRebuild;
    private final Object rebuildRegionLock = new String("rebuild-region-lock");
    private final DocumentView docView;
    private EditorViewFactory[] viewFactories;
    private DocumentListener incomingModificationListener;
    private OffsetRegion rebuildRegion;
    private boolean buildingViews;
    private DocumentEvent incomingEvent;
    private final RequestProcessor.Task rebuildRegionTask = rebuildRegionRP.create((Runnable)new RebuildViews());
    private boolean listenerPriorityAwareDoc;

    public ViewUpdates(DocumentView docView) {
        this.docView = docView;
        this.incomingModificationListener = new IncomingModificationListener();
        Document doc = docView.getDocument();
        this.listenerPriorityAwareDoc = DocumentUtilities.addPriorityDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this.incomingModificationListener, null)), (DocumentListenerPriority)DocumentListenerPriority.FIRST);
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc)), (DocumentListenerPriority)DocumentListenerPriority.VIEW);
        assert (this.viewFactories == null);
        JTextComponent component = docView.getTextComponent();
        assert (component != null) : "Null component; doc=" + docView.getDocument();
        List<EditorViewFactory.Factory> factoryFactories = EditorViewFactory.factories();
        this.viewFactories = new EditorViewFactory[factoryFactories.size()];
        for (int i = 0; i < factoryFactories.size(); ++i) {
            this.viewFactories[i] = factoryFactories.get(i).createEditorViewFactory(component);
            this.viewFactories[i].addEditorViewFactoryListener((EditorViewFactoryListener)WeakListeners.create(EditorViewFactoryListener.class, (EventListener)this, (Object)this.viewFactories[i]));
        }
    }

    private ViewBuilder startBuildViews() {
        assert (!this.isBuildingViews()) : "Already building views";
        ViewBuilder viewBuilder = new ViewBuilder(this.docView, this.viewFactories);
        this.docView.checkMutexAcquiredIfLogging();
        this.setBuildingViews(true);
        return viewBuilder;
    }

    private void finishBuildViews(ViewBuilder viewBuilder) {
        this.setBuildingViews(false);
        viewBuilder.finish();
        this.docView.checkIntegrityIfLoggable();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finer("ViewUpdates.buildViews(): UPDATED-DOC-VIEW:\n" + this.docView);
        }
    }

    private boolean isBuildingViews() {
        return this.buildingViews;
    }

    private void setBuildingViews(boolean buildingViews) {
        assert (buildingViews != this.buildingViews) : "buildingViews=" + buildingViews + " == this.buildingViews=" + this.buildingViews;
        this.buildingViews = buildingViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitAllViews() {
        ViewBuilder viewBuilder = this.startBuildViews();
        try {
            this.fetchRebuildRegion();
            viewBuilder.initFullRebuild();
            viewBuilder.createReplaceAndRepaintViews();
        }
        finally {
            this.finishBuildViews(viewBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initChildren(int startIndex, int endIndex) {
        int viewCount;
        if (endIndex - startIndex < 5) {
            startIndex -= 2;
            endIndex += 2;
        }
        if ((viewCount = this.docView.getViewCount()) == 0) {
            return;
        }
        startIndex = Math.max(startIndex, 0);
        endIndex = Math.min(endIndex, viewCount);
        assert (startIndex >= 0) : "startIndex=" + startIndex;
        assert (endIndex >= startIndex) : "endIndex=" + endIndex + " < startIndex=" + startIndex;
        ParagraphView startChild = (ParagraphView)this.docView.getEditorView(startIndex);
        while (startChild.children != null && startIndex < endIndex - 1) {
            startChild = (ParagraphView)this.docView.getEditorView(++startIndex);
        }
        ParagraphView lastChild = null;
        while (endIndex > startIndex) {
            lastChild = (ParagraphView)this.docView.getEditorView(endIndex - 1);
            if (lastChild.children == null) break;
            --endIndex;
        }
        if (endIndex > startIndex) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Lazy-children init: [" + startIndex + "," + endIndex + "]\n");
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.INFO, "Lazy creation cause", new Exception());
                }
            }
            ViewBuilder viewBuilder = this.startBuildViews();
            try {
                viewBuilder.initParagraphs(startIndex, endIndex, startChild.getStartOffset(), lastChild.getEndOffset());
                viewBuilder.createReplaceAndRepaintViews();
            }
            finally {
                this.finishBuildViews(viewBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        PriorityMutex mutex = this.docView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.docView.checkDocumentLockedIfLogging();
            try {
                if (!this.docView.isUpdatable() || this.docView.getViewCount() == 0) {
                    return;
                }
                Document doc = this.docView.getDocument();
                assert (doc == evt.getDocument()) : "Invalid document";
                int insertOffset = evt.getOffset();
                int insertLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-INSERT-evt: offset=" + insertOffset + ", length=" + insertLength + ", current-docViewEndOffset=" + (evt.getDocument().getLength() + 1) + '\n');
                }
                ViewBuilder viewBuilder = this.startBuildViews();
                try {
                    if (viewBuilder.initModUpdate(insertOffset, insertLength, this.fetchRebuildRegion())) {
                        viewBuilder.createReplaceAndRepaintViews();
                    }
                }
                finally {
                    this.finishBuildViews(viewBuilder);
                }
            }
            finally {
                this.docView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        PriorityMutex mutex = this.docView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.docView.checkDocumentLockedIfLogging();
            try {
                if (!this.docView.isUpdatable() || this.docView.getViewCount() == 0) {
                    return;
                }
                Document doc = this.docView.getDocument();
                assert (doc == evt.getDocument()) : "Invalid document";
                int removeOffset = evt.getOffset();
                int removeLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-REMOVE-evt: offset=" + removeOffset + ", length=" + removeLength + ", current-docViewEndOffset=" + (evt.getDocument().getLength() + 1) + '\n');
                }
                ViewBuilder viewBuilder = this.startBuildViews();
                try {
                    if (viewBuilder.initModUpdate(removeOffset, -removeLength, this.fetchRebuildRegion())) {
                        viewBuilder.createReplaceAndRepaintViews();
                    }
                }
                finally {
                    this.finishBuildViews(viewBuilder);
                }
            }
            finally {
                this.docView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        PriorityMutex mutex = this.docView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.docView.checkDocumentLockedIfLogging();
            try {
                if (!this.docView.isUpdatable()) {
                    return;
                }
                this.docView.checkIntegrityIfLoggable();
            }
            finally {
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewFactoryChanged(EditorViewFactoryEvent evt) {
        boolean postRebuildTask;
        boolean directRebuild = directViewRebuild;
        Object object = this.rebuildRegionLock;
        synchronized (object) {
            this.docView.checkDocumentLockedIfLogging();
            postRebuildTask = this.rebuildRegion == null;
            directRebuild |= evt.getPriority() > 0;
            if (this.isBuildingViews()) {
                directRebuild = false;
            }
            List<EditorViewFactory.Change> changes = evt.getChanges();
            for (EditorViewFactory.Change change : changes) {
                int startOffset = change.getStartOffset();
                int endOffset = change.getEndOffset();
                Document doc = this.docView.getDocument();
                int docTextLen = doc.getLength() + 1;
                startOffset = Math.min(startOffset, docTextLen);
                endOffset = Math.min(endOffset, docTextLen);
                this.rebuildRegion = OffsetRegion.union(this.rebuildRegion, doc, startOffset, endOffset, false);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("ViewUpdates.viewFactoryChanged: <" + startOffset + "," + endOffset + ">\n");
            }
        }
        if (directRebuild) {
            new RebuildViews().run();
        } else if (postRebuildTask) {
            this.rebuildRegionTask.schedule(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncedViewsRebuild() {
        OffsetRegion region;
        if (this.docView.isActive() && (region = this.fetchRebuildRegion()) != null) {
            this.docView.checkDocumentLockedIfLogging();
            ViewBuilder viewBuilder = this.startBuildViews();
            try {
                if (viewBuilder.initRebuild(region)) {
                    viewBuilder.createReplaceAndRepaintViews();
                }
            }
            finally {
                this.finishBuildViews(viewBuilder);
            }
        }
    }

    static void setDirectViewRebuild(boolean directRebuild) {
        directViewRebuild = directRebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffsetRegion fetchRebuildRegion() {
        Object object = this.rebuildRegionLock;
        synchronized (object) {
            OffsetRegion region = this.rebuildRegion;
            this.rebuildRegion = null;
            return region;
        }
    }

    void incomingEvent(DocumentEvent evt) {
        if (this.incomingEvent != null) {
            this.docView.releaseChildren();
            LOG.log(Level.INFO, "View hierarchy rebuild due to pending document event", new Exception("Pending incoming event: " + this.incomingEvent));
        }
        this.incomingEvent = evt;
    }

    private void clearIncomingEvent(DocumentEvent evt) {
        if (this.listenerPriorityAwareDoc) {
            if (this.incomingEvent == null) {
                throw new IllegalStateException("Incoming event already cleared");
            }
            if (this.incomingEvent != evt) {
                throw new IllegalStateException("Invalid incomingEvent=" + this.incomingEvent + " != evt=" + evt);
            }
            this.incomingEvent = null;
        }
    }

    private final class RebuildViews
    implements Runnable {
        private RebuildViews() {
        }

        @Override
        public void run() {
            ViewUpdates.this.docView.syncViewsRebuild();
        }
    }

    private final class IncomingModificationListener
    implements DocumentListener {
        private IncomingModificationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
            ViewUpdates.this.docView.setIncomingModification(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
            ViewUpdates.this.docView.setIncomingModification(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
        }
    }
}

