# Cybersecurity AI (`CAI`)

A lightweight, ergonomic framework for building bug bounty-ready Cybersecurity AIs (CAIs).

<div align="center">
  <p>
    <a align="center" href="" target="https://github.com/aliasrobotics/CAI">
      <img
        width="100%"
        src="https://github.com/aliasrobotics/cai/raw/main/media/cai.png"
      >
    </a>
  </p>
</div>

## Key Features

- 🤖 **300+ AI Models**: Support for OpenAI, Anthropic, DeepSeek, Ollama, and more
- 🔧 **Built-in Security Tools**: Ready-to-use tools for reconnaissance, exploitation, and privilege escalation
- 🏆 **Battle-tested**: Proven in HackTheBox CTFs, bug bounties, and real-world security case studies
- 🎯 **Agent-based Architecture**: Modular framework design to build specialized agents for different security tasks
- 🛡️ **Guardrails Protection**: Built-in defenses against prompt injection and dangerous command execution
- 📚 **Research-oriented**: Research foundation to democratize cybersecurity AI for the community

---

## 🚀 CAI PRO - Professional Edition

<div class="highlight-box" markdown>

### Upgrade to Unrestricted AI for Security Professionals

**CAI PRO** delivers the power you need for professional security testing:

- ✅ **Unlimited `alias1` tokens** - Our state-of-the-art cybersecurity model that beats GPT-5 in benchmarks
- ✅ **Mobile User Interface (iOS)** - Native iOS app for security testing on the go - **[Join TestFlight Beta](https://testflight.apple.com/join/nXZZD4Z5)**
- ✅ **Terminal User Interface (TUI)** - Multi-agent parallel execution with visual monitoring *(Deprecated - Use Mobile UI)*
- ✅ **Context Monitoring** - Real-time token tracking and optimization
- ✅ **Zero Refusals** - Unrestricted AI specifically trained for offensive security
- ✅ **European Hosting** - GDPR & NIS2 compliant with guaranteed data privacy
- ✅ **Professional Support** - Dedicated technical assistance from security experts

**Pricing**: €350/month · Commercial license included · Cancel anytime

**[Learn More & Upgrade to CAI PRO →](cai_pro.md)**

</div>

---

| CAI with `alias0` on ROS message injection attacks in MiR-100 robot | CAI with `alias0` on API vulnerability discovery at Mercado Libre |
|-----------------------------------------------|---------------------------------|
| [![asciicast](https://asciinema.org/a/dNv705hZel2Rzrw0cju9HBGPh.svg)](https://asciinema.org/a/dNv705hZel2Rzrw0cju9HBGPh) | [![asciicast](https://asciinema.org/a/9Hc9z1uFcdNjqP3bY5y7wO1Ww.svg)](https://asciinema.org/a/9Hc9z1uFcdNjqP3bY5y7wO1Ww) |


| CAI on JWT@PortSwigger CTF — Cybersecurity AI | CAI on HackableII Boot2Root CTF — Cybersecurity AI |
|-----------------------------------------------|---------------------------------|
| [![asciicast](https://asciinema.org/a/713487.svg)](https://asciinema.org/a/713487) | [![asciicast](https://asciinema.org/a/713485.svg)](https://asciinema.org/a/713485) |


## 🎯 Milestones
<p>
<a href="https://app.hackthebox.com/users/2268644"><img src="https://img.shields.io/badge/HTB_ranking-top_90_Spain_(5_days)-red.svg" alt="HTB top 90 Spain (5 days)"></a>
<a href="https://app.hackthebox.com/users/2268644"><img src="https://img.shields.io/badge/HTB_ranking-top_50_Spain_(6_days)-red.svg" alt="HTB ranking top 50 Spain (6 days)"></a>
<a href="https://app.hackthebox.com/users/2268644"><img src="https://img.shields.io/badge/HTB_ranking-top_30_Spain_(7_days)-red.svg" alt="HTB ranking top 30 Spain (7 days)"></a>
<a href="https://app.hackthebox.com/users/2268644"><img src="https://img.shields.io/badge/HTB_ranking-top_500_World_(7_days)-red.svg" alt="HTB ranking top 500 World (7 days)"></a>
<a href="https://ctf.hackthebox.com/event/2000/scoreboard"><img src="https://img.shields.io/badge/HTB_Human_vs_AI_CTF-top_1_(AIs)_world-red.svg" alt="HTB Human vs AI CTF top 1 (AIs) world"></a>
<a href="https://ctf.hackthebox.com/event/2000/scoreboard"><img src="https://img.shields.io/badge/HTB_Human_vs_AI_CTF-top_1_Spain-red.svg" alt="HTB Human vs AI CTF top 1 Spain"></a>
<a href="https://ctf.hackthebox.com/event/2000/scoreboard"><img src="https://img.shields.io/badge/HTB_Human_vs_AI_CTF-top_20_World-red.svg" alt="HTB Human vs AI CTF top 20 World"></a>
<a href="https://ctf.hackthebox.com/event/2000/scoreboard"><img src="https://img.shields.io/badge/HTB_Human_vs_AI_CTF-750_$-yellow.svg" alt="HTB Human vs AI CTF 750 $"></a>
<a href="https://lu.ma/roboticshack?tk=RuryKF"><img src="https://img.shields.io/badge/Mistral_AI_Robotics_Hackathon-2500_$-yellow.svg" alt="Mistral AI Robotics Hackathon 2500 $"></a>
<a href="https://github.com/aliasrobotics/cai"><img src="https://img.shields.io/badge/Bug_rewards-250_$-yellow.svg" alt="Bug rewards 250 $"></a>
</p>

## 📦 Package Attributes
<p>
<a href="https://badge.fury.io/py/cai-framework"><img src="https://badge.fury.io/py/cai-framework.svg" alt="version"></a>
<a href="https://pypistats.org/packages/cai-framework"><img src="https://img.shields.io/pypi/dm/cai-framework" alt="downloads"></a>
<a href="https://github.com/aliasrobotics/cai"><img src="https://img.shields.io/badge/Linux-Supported-brightgreen?logo=linux&logoColor=white" alt="Linux"></a>
<a href="https://github.com/aliasrobotics/cai"><img src="https://img.shields.io/badge/OS%20X-Supported-brightgreen?logo=apple&logoColor=white" alt="OS X"></a>
<a href="https://github.com/aliasrobotics/cai"><img src="https://img.shields.io/badge/Windows-Supported-brightgreen?logo=windows&logoColor=white" alt="Windows"></a>
<a href="https://github.com/aliasrobotics/cai"><img src="https://img.shields.io/badge/Android-Supported-brightgreen?logo=android&logoColor=white" alt="Android"></a>
<a href="https://discord.gg/fnUFcTaQAC"><img src="https://img.shields.io/badge/Discord-7289DA?logo=discord&logoColor=white" alt="Discord"></a>
<a href="https://arxiv.org/pdf/2504.06017"><img src="https://img.shields.io/badge/arXiv-2504.06017-b31b1b.svg" alt="arXiv"></a>
</p>

---

## 📊 Research-Backed Performance

CAI's capabilities are validated through rigorous peer-reviewed research demonstrating state-of-the-art performance:

!!! tip "Research Highlights"
    - 🚀 **[3,600× faster](https://arxiv.org/pdf/2504.06017)** than manual security testing in specific scenarios
    - 🎯 **[54.3% patching success](https://arxiv.org/pdf/2510.17521)** in real-world CTF defense scenarios
    - 📊 **[Superior benchmark performance](https://arxiv.org/pdf/2510.24317)** via CAIBench meta-framework evaluation
    - 🛡️ **[Four-layer guardrails](https://arxiv.org/pdf/2508.21669)** against prompt injection attacks

### Key Publications

- 📊 [**CAIBench**](https://arxiv.org/pdf/2510.24317) - Modular meta-benchmark framework for evaluating cybersecurity AI agents
- 🎯 [**Agentic Cybersecurity Evaluation**](https://arxiv.org/pdf/2510.17521) - Real-world CTF performance validation
- 🚀 [**CAI Framework**](https://arxiv.org/pdf/2504.06017) - Core architecture demonstrating 3,600× speedup
- 🛡️ [**Prompt Injection Defense**](https://arxiv.org/pdf/2508.21669) - Security guardrails for AI agents
- 📚 [**CAI Fluency**](https://arxiv.org/pdf/2508.13588) - Educational framework for democratizing AI security
- 🤖 [**Automation vs Autonomy**](https://www.arxiv.org/pdf/2506.23592) - 6-level taxonomy for cybersecurity AI

**📖 Explore all 24+ papers:** [Alias Robotics Research Library →](https://aliasrobotics.com/research-security.php#papers)

---

> ⚠️ CAI is in active development, so don't expect it to work flawlessly. Instead, contribute by raising an issue or [sending a PR](https://github.com/aliasrobotics/cai/pulls).
>
> Access to this library and the use of information, materials (or portions thereof), is **<u>not intended</u>, and is <u>prohibited</u>, where such access or use violates applicable laws or regulations**. By no means the authors encourage or promote the unauthorized tampering with running systems. This can cause serious human harm and material damages.
>
> *By no means the authors of CAI encourage or promote the unauthorized tampering with compute systems. Please don't use the source code in here for cybercrime. <u>Pentest for good instead</u>*. By downloading, using, or modifying this source code, you agree to the terms of the [`LICENSE`](LICENSE) and the limitations outlined in the [`DISCLAIMER`](DISCLAIMER) file.


## Motivation
### Why CAI?
The cybersecurity landscape is undergoing a dramatic transformation as AI becomes increasingly integrated into security operations. **We predict that by 2028, AI-powered security testing tools will outnumber human pentesters**. This shift represents a fundamental change in how we approach cybersecurity challenges. *AI is not just another tool - it's becoming essential for addressing complex security vulnerabilities and staying ahead of sophisticated threats. As organizations face more advanced cyber attacks, AI-enhanced security testing will be crucial for maintaining robust defenses.*

This work builds upon prior efforts[1] and similarly, we believe that democratizing access to advanced cybersecurity AI tools is vital for the entire security community. That's why we're releasing Cybersecurity AI (`CAI`) as an open source framework. Our goal is to empower security researchers, ethical hackers, and organizations to build and deploy powerful AI-driven security tools. By making these capabilities openly available, we aim to level the playing field and ensure that cutting-edge security AI technology isn't limited to well-funded private companies or state actors.

Bug Bounty programs have become a cornerstone of modern cybersecurity, providing a crucial mechanism for organizations to identify and fix vulnerabilities in their systems before they can be exploited. These programs have proven highly effective at securing both public and private infrastructure, with researchers discovering critical vulnerabilities that might have otherwise gone unnoticed. CAI is specifically designed to enhance these efforts by providing a lightweight, ergonomic framework for building specialized AI agents that can assist in various aspects of Bug Bounty hunting - from initial reconnaissance to vulnerability validation and reporting. Our framework aims to augment human expertise with AI capabilities, helping researchers work more efficiently and thoroughly in their quest to make digital systems more secure.

### Ethical principles behind CAI

You might be wondering if releasing CAI *in-the-wild* given its capabilities and security implications is ethical. Our decision to open-source this framework is guided by two core ethical principles:

1. **Democratizing Cybersecurity AI**: We believe that advanced cybersecurity AI tools should be accessible to the entire security community, not just well-funded private companies or state actors. By releasing CAI as an open source framework, we aim to empower security researchers, ethical hackers, and organizations to build and deploy powerful AI-driven security tools, leveling the playing field in cybersecurity.

2. **Transparency in AI Security Capabilities**: Based on our research results, understanding of the technology, and dissection of top technical reports, we argue that current LLM vendors are undermining their cybersecurity capabilities. This is extremely dangerous and misleading. By developing CAI openly, we provide a transparent benchmark of what AI systems can actually do in cybersecurity contexts, enabling more informed decisions about security postures.

CAI is built on the following core principles:

- **Cybersecurity oriented AI framework**: CAI is specifically designed for cybersecurity use cases, aiming at semi- and fully-automating offensive and defensive security tasks.
- **Open source, free for research**: CAI is open source and free for research purposes. We aim at democratizing access to AI and Cybersecurity. For professional or commercial use, including on-premise deployments, dedicated technical support and custom extensions [reach out](mailto:research@aliasrobotics.com) to obtain a license.
- **Lightweight**: CAI is designed to be fast, and easy to use.
- **Modular and agent-centric design**: CAI operates on the basis of agents and agentic patterns, which allows flexibility and scalability. You can easily add the most suitable agents and pattern for your cybersecurity target case.
- **Tool-integration**: CAI integrates already built-in tools, and allows the user to integrate their own tools with their own logic easily.
- **Logging and tracing integrated**: using [`phoenix`](https://github.com/Arize-ai/phoenix), the open source tracing and logging tool for LLMs. This provides the user with a detailed traceability of the agents and their execution.
- **Multi-Model Support**: more than 300 supported and empowered by [LiteLLM](https://github.com/BerriAI/litellm). The most popular providers:

### Popular Model Providers
* **Anthropic**: `Claude 3.7`, `Claude 3.5`, `Claude 3`, `Claude 3 Opus`
* **OpenAI**: `O1`, `O1 Mini`, `O3 Mini`, `GPT-4o`, `GPT-4.5 Preview`
* **DeepSeek**: `DeepSeek V3`, `DeepSeek R1`
* **Ollama**: `Qwen2.5 72B`, `Qwen2.5 14B`, And many more

### Closed-source alternatives
Cybersecurity AI is a critical field, yet many groups are misguidedly pursuing it through closed-source methods for pure economic return, leveraging similar techniques and building upon existing closed-source (*often third-party owned*) models. This approach not only squanders valuable engineering resources but also represents an economic waste and results in redundant efforts, as they often end up reinventing the wheel. Here are some of the closed-source initiatives we keep track of and attempting to leverage genAI and agentic frameworks in cybersecurity AI:

- [Runsybil](https://www.runsybil.com)
- [Selfhack](https://www.selfhack.fi)
- [Sxipher](https://www.sxipher.com/) (seems discontinued)
- [Staris](https://staris.tech/)
- [Terra Security](https://www.terra.security)
- [Xint](https://xint.io/)
- [XBOW](https://www.xbow.com)
- [ZeroPath](https://www.zeropath.com)
- [Zynap](https://www.zynap.com)

---

[1] Deng, G., Liu, Y., Mayoral-Vilches, V., Liu, P., Li, Y., Xu, Y., ... & Rass, S. (2024). {PentestGPT}: Evaluating and harnessing large language models for automated penetration testing. In 33rd USENIX Security Symposium (USENIX Security 24) (pp. 847-864).

## Citation
If you want to cite our work, please use the following:

```bibtex
@article{mayoral2025cai,
  title={CAI: An Open, Bug Bounty-Ready Cybersecurity AI},
  author={Mayoral-Vilches, V{\'\i}ctor and Navarrete-Lozano, Luis Javier and Sanz-G{\'o}mez, Mar{\'\i}a and Espejo, Lidia Salas and Crespo-{\'A}lvarez, Marti{\~n}o and Oca-Gonzalez, Francisco and Balassone, Francesco and Glera-Pic{\'o}n, Alfonso and Ayucar-Carbajo, Unai and Ruiz-Alcalde, Jon Ander and Rass, Stefan and Pinzger, Martin and Gil-Uriarte, Endika},
  journal={arXiv preprint arXiv:2504.06017},
  year={2025}
}

@article{mayoral2025automation,
  title={Cybersecurity AI: The Dangerous Gap Between Automation and Autonomy},
  author={Mayoral-Vilches, V{\'\i}ctor},
  journal={arXiv preprint arXiv:2506.23592},
  year={2025}
}

@article{mayoral2025fluency,
  title={CAI Fluency: A Framework for Cybersecurity AI Fluency},
  author={Mayoral-Vilches, V{\'\i}ctor and Wachter, Jasmin and Chavez, Crist{\'o}bal RJ and Schachner, Cathrin and Navarrete-Lozano, Luis Javier and Sanz-G{\'o}mez, Mar{\'\i}a},
  journal={arXiv preprint arXiv:2508.13588},
  year={2025}
}

@article{mayoral2025hacking,
  title={Cybersecurity AI: Hacking the AI Hackers via Prompt Injection},
  author={Mayoral-Vilches, V{\'\i}ctor and Rynning, Per Mannermaa},
  journal={arXiv preprint arXiv:2508.21669},
  year={2025}
}

@article{mayoral2025humanoid,
  title={Cybersecurity AI: Humanoid Robots as Attack Vectors},
  author={Mayoral-Vilches, V{\'\i}ctor},
  journal={arXiv preprint arXiv:2509.14139},
  year={2025}
}

@article{balassone2025evaluation,
  title={Cybersecurity AI: Evaluating Agentic Cybersecurity in Attack/Defense CTFs},
  author={Balassone, Francesco and Mayoral-Vilches, V{\'\i}ctor and Rass, Stefan and Pinzger, Martin and Perrone, Gaetano and Romano, Simon Pietro and Schartner, Peter},
  journal={arXiv preprint arXiv:2510.17521},
  year={2025}
}

@article{mayoral2025caibench,
  title={CAIBench: A Meta-Benchmark for Evaluating Cybersecurity AI Agents},
  author={Mayoral-Vilches, V{\'\i}ctor and Balassone, Francesco and Navarrete-Lozano, Luis Javier and Sanz-G{\'o}mez, Mar{\'\i}a and Crespo-{\'A}lvarez, Marti{\~n}o and Rass, Stefan and Pinzger, Martin},
  journal={arXiv preprint arXiv:2510.24317},
  year={2025}
} 

```

## Acknowledgements

CAI was initially developed by [Alias Robotics](https://aliasrobotics.com) and co-funded by the European EIC accelerator project RIS (GA 101161136) - HORIZON-EIC-2023-ACCELERATOR-01 call. The original agentic principles are inspired from OpenAI's [`swarm`](https://github.com/openai/swarm) library and translated into newer prototypes. This project also makes use of other relevant open source building blocks including [`LiteLLM`](https://github.com/BerriAI/litellm), and [`phoenix`](https://github.com/Arize-ai/phoenix).