/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WScanBoxedGeneral {
    public final Component component;
    private final JCheckBox useBannerFileCB = new JCheckBox("Use Banner File");
    private final JTextField bannerFileTF = new JTextField();
    private final JButton bannerFileChooserB = new FileChooserButton(WScan.getWScanWindow(), "Select Banner File", 0, this.bannerFileTF);
    private final JCheckBox useAlertlistFileCB = new JCheckBox("Use Alert List File");
    private final JTextField alertlistFileTF = new JTextField();
    private final JButton alertlistFileChooserB = new FileChooserButton(WScan.getWScanWindow(), "Select Alert List File", 0, this.alertlistFileTF);
    private final JCheckBox useStoplistFileCB = new JCheckBox("Use Stop List File");
    private final JTextField stoplistFileTF = new JTextField();
    private final JButton stoplistFileChooserB = new FileChooserButton(WScan.getWScanWindow(), "Select Stop List File", 0, this.stoplistFileTF);
    private final JCheckBox useFindRegexTextFileCB = new JCheckBox("Use Find Regex Text File");
    private final JTextField findRegexTextFileTF = new JTextField();
    private final JButton findRegexTextFileChooserB = new FileChooserButton(WScan.getWScanWindow(), "Select Find Regex Text File", 0, this.findRegexTextFileTF);
    private final JCheckBox useFindRegexTextCB = new JCheckBox("Use Find Regex Text");
    private final JTextField findRegexTextTF = new JTextField();
    private final JCheckBox useRandomSamplingCB = new JCheckBox("Use Random Sampling");
    private final JTextField randomSamplingTF = new JTextField();

    public WScanBoxedGeneral() {
        this.component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("General Options"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        WScan.addOptionalFileLine(jPanel, n++, this.useBannerFileCB, this.bannerFileTF, this.bannerFileChooserB);
        WScan.addOptionalFileLine(jPanel, n++, this.useAlertlistFileCB, this.alertlistFileTF, this.alertlistFileChooserB);
        WScan.addOptionalFileLine(jPanel, n++, this.useStoplistFileCB, this.stoplistFileTF, this.stoplistFileChooserB);
        WScan.addOptionalFileLine(jPanel, n++, this.useFindRegexTextFileCB, this.findRegexTextFileTF, this.findRegexTextFileChooserB);
        WScan.addOptionalTextLine(jPanel, n++, this.useFindRegexTextCB, this.findRegexTextTF, 250);
        WScan.addOptionalTextLine(jPanel, n++, this.useRandomSamplingCB, this.randomSamplingTF, 100);
        this.useRandomSamplingCB.setToolTipText("Random Sampling in form frac[:passes]");
        return jPanel;
    }

    public void setScanSettings(ScanSettings scanSettings) {
        this.useBannerFileCB.setSelected(scanSettings.useBannerFile);
        this.bannerFileTF.setEnabled(scanSettings.useBannerFile);
        this.bannerFileTF.setText(scanSettings.bannerFile);
        this.bannerFileChooserB.setEnabled(scanSettings.useBannerFile);
        this.useAlertlistFileCB.setSelected(scanSettings.useAlertlistFile);
        this.alertlistFileTF.setEnabled(scanSettings.useAlertlistFile);
        this.alertlistFileTF.setText(scanSettings.alertlistFile);
        this.alertlistFileChooserB.setEnabled(scanSettings.useAlertlistFile);
        this.useStoplistFileCB.setSelected(scanSettings.useStoplistFile);
        this.stoplistFileTF.setEnabled(scanSettings.useStoplistFile);
        this.stoplistFileTF.setText(scanSettings.stoplistFile);
        this.stoplistFileChooserB.setEnabled(scanSettings.useStoplistFile);
        this.useFindRegexTextFileCB.setSelected(scanSettings.useFindRegexTextFile);
        this.findRegexTextFileTF.setEnabled(scanSettings.useFindRegexTextFile);
        this.findRegexTextFileTF.setText(scanSettings.findRegexTextFile);
        this.findRegexTextFileChooserB.setEnabled(scanSettings.useFindRegexTextFile);
        this.useFindRegexTextCB.setSelected(scanSettings.useFindRegexText);
        this.findRegexTextTF.setEnabled(scanSettings.useFindRegexText);
        this.findRegexTextTF.setText(scanSettings.findRegexText);
        this.useRandomSamplingCB.setSelected(scanSettings.useRandomSampling);
        this.randomSamplingTF.setEnabled(scanSettings.useRandomSampling);
        this.randomSamplingTF.setText(scanSettings.randomSampling);
    }

    public void getScanSettings(ScanSettings scanSettings) {
        scanSettings.useBannerFile = this.useBannerFileCB.isSelected();
        scanSettings.bannerFile = this.bannerFileTF.getText();
        scanSettings.useAlertlistFile = this.useAlertlistFileCB.isSelected();
        scanSettings.alertlistFile = this.alertlistFileTF.getText();
        scanSettings.useStoplistFile = this.useStoplistFileCB.isSelected();
        scanSettings.stoplistFile = this.stoplistFileTF.getText();
        scanSettings.useFindRegexTextFile = this.useFindRegexTextFileCB.isSelected();
        scanSettings.findRegexTextFile = this.findRegexTextFileTF.getText();
        scanSettings.useFindRegexText = this.useFindRegexTextCB.isSelected();
        scanSettings.findRegexText = this.findRegexTextTF.getText();
        scanSettings.useRandomSampling = this.useRandomSamplingCB.isSelected();
        scanSettings.randomSampling = this.randomSamplingTF.getText();
    }

    private void wireActions() {
        GetUIValuesActionListener getUIValuesActionListener = new GetUIValuesActionListener();
        this.useBannerFileCB.addActionListener(getUIValuesActionListener);
        this.useAlertlistFileCB.addActionListener(getUIValuesActionListener);
        this.useStoplistFileCB.addActionListener(getUIValuesActionListener);
        this.useFindRegexTextFileCB.addActionListener(getUIValuesActionListener);
        this.useFindRegexTextCB.addActionListener(getUIValuesActionListener);
        this.useRandomSamplingCB.addActionListener(getUIValuesActionListener);
    }

    private class GetUIValuesActionListener
    implements ActionListener {
        private GetUIValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScanSettings scanSettings = new ScanSettings();
            WScanBoxedGeneral.this.getScanSettings(scanSettings);
            WScanBoxedGeneral.this.setScanSettings(scanSettings);
        }
    }
}

