/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class WScan {
    public static final int NARROW_FIELD_WIDTH = 50;
    public static final int WIDE_FIELD_WIDTH = 100;
    public static final int EXTRA_WIDE_FIELD_WIDTH = 250;
    private static WScan wScan;
    private final JDialog wScanWindow = new JDialog();
    private final JButton queueB = new JButton("Manage Queue\u2026");
    private final JButton importB = new JButton("Import\u2026");
    private final JButton submitB = new JButton("Submit Run");
    private final JButton cancelB = new JButton("Cancel");
    private final WScanBoxedRequired wScanBoxedRequired;
    private final WScanBoxedGeneral wScanBoxedGeneral;
    private final WScanBoxedTuning wScanBoxedTuning;
    private final WScanBoxedControls wScanBoxedControls;
    private final WScanBoxedParallelizing wScanBoxedParallelizing;
    private final WScanBoxedDebugging wScanBoxedDebugging;
    private final WScanBoxedScanners wScanBoxedScanners;

    public static Component getWScanWindow() {
        return WScan.wScan.wScanWindow;
    }

    public static void openWindow(ScanSettings scanSettings) {
        if (wScan == null) {
            new WScan();
        }
        if (WScan.wScan.wScanWindow.isVisible()) {
            WLog.log("WScan already visible.  Replacing scan settings.");
        }
        wScan.setScanSettings(scanSettings);
        WScan.wScan.wScanWindow.setLocationRelativeTo(BEViewer.getBEWindow());
        WScan.wScan.wScanWindow.getRootPane().setDefaultButton(WScan.wScan.submitB);
        WScan.wScan.wScanWindow.setVisible(true);
    }

    private WScan() {
        wScan = this;
        this.wScanBoxedRequired = new WScanBoxedRequired();
        this.wScanBoxedGeneral = new WScanBoxedGeneral();
        this.wScanBoxedTuning = new WScanBoxedTuning();
        this.wScanBoxedParallelizing = new WScanBoxedParallelizing();
        this.wScanBoxedDebugging = new WScanBoxedDebugging();
        this.wScanBoxedControls = new WScanBoxedControls();
        this.wScanBoxedScanners = new WScanBoxedScanners();
        this.buildScanInterface();
        this.wireActions();
        this.wScanWindow.pack();
    }

    private void buildScanInterface() {
        this.wScanWindow.setTitle("Run bulk_extractor");
        JPanel jPanel = new JPanel();
        this.wScanWindow.getContentPane().add(jPanel);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.buildOptionsScrollPane(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add(this.buildControlContainer(), gridBagConstraints);
    }

    private JScrollPane buildOptionsScrollPane() {
        Container container = this.buildOptionsContainer();
        JScrollPane jScrollPane = new JScrollPane(container);
        jScrollPane.getViewport().setBackground(this.wScanBoxedRequired.component.getBackground());
        return jScrollPane;
    }

    private Container buildOptionsContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 23;
        container.add(this.wScanBoxedRequired.component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 23;
        container.add(this.wScanBoxedGeneral.component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 23;
        container.add(this.wScanBoxedTuning.component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 23;
        container.add(this.wScanBoxedParallelizing.component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 23;
        container.add(this.wScanBoxedDebugging.component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        container.add(this.wScanBoxedControls.component, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 23;
        container.add(WScanBoxedScanners.component, gridBagConstraints);
        return container;
    }

    private Component buildControlContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.queueB, gridBagConstraints);
        this.queueB.setToolTipText("Manage the bulk_extractor Run Queue");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.importB, gridBagConstraints);
        this.importB.setToolTipText("Import settings for a new bulk_extractor run");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.submitB, gridBagConstraints);
        this.submitB.setToolTipText("Submit run to the bulk_extractor Run Queue");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.cancelB, gridBagConstraints);
        return container;
    }

    public static void addOptionalFileLine(Container container, int n, JCheckBox jCheckBox, JTextField jTextField, JButton jButton) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        jTextField.setMinimumSize(new Dimension(250, jTextField.getPreferredSize().height));
        jTextField.setPreferredSize(new Dimension(250, jTextField.getPreferredSize().height));
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        container.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        container.add((Component)jButton, gridBagConstraints);
    }

    public static void addOptionalTextLine(Container container, int n, JCheckBox jCheckBox, JTextField jTextField, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)jCheckBox, gridBagConstraints);
        jTextField.setMinimumSize(new Dimension(n2, jTextField.getPreferredSize().height));
        jTextField.setPreferredSize(new Dimension(n2, jTextField.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        container.add((Component)jTextField, gridBagConstraints);
    }

    public static void addOptionLine(Container container, int n, JCheckBox jCheckBox) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)jCheckBox, gridBagConstraints);
    }

    private void setScanSettings(ScanSettings scanSettings) {
        this.wScanBoxedRequired.setScanSettings(scanSettings);
        this.wScanBoxedGeneral.setScanSettings(scanSettings);
        this.wScanBoxedTuning.setScanSettings(scanSettings);
        this.wScanBoxedParallelizing.setScanSettings(scanSettings);
        this.wScanBoxedDebugging.setScanSettings(scanSettings);
        this.wScanBoxedControls.setScanSettings(scanSettings);
        this.wScanBoxedScanners.setScanSettings(scanSettings);
    }

    private void getScanSettings(ScanSettings scanSettings) {
        this.wScanBoxedRequired.getScanSettings(scanSettings);
        this.wScanBoxedGeneral.getScanSettings(scanSettings);
        this.wScanBoxedTuning.getScanSettings(scanSettings);
        this.wScanBoxedParallelizing.getScanSettings(scanSettings);
        this.wScanBoxedDebugging.getScanSettings(scanSettings);
        this.wScanBoxedControls.getScanSettings(scanSettings);
        this.wScanBoxedScanners.getScanSettings(scanSettings);
    }

    private void wireActions() {
        this.queueB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanSettingsRunQueue.openWindow();
            }
        });
        this.submitB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = new ScanSettings();
                WScan.this.getScanSettings(scanSettings);
                WLog.log("WScan submit scan settings: '" + scanSettings.getCommandString() + "'\n");
                boolean bl = scanSettings.validateSomeSettings();
                if (!bl) {
                    return;
                }
                BEViewer.scanSettingsListModel.add(scanSettings);
                WScan.this.wScanWindow.setVisible(false);
            }
        });
        this.importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = new ScanSettings();
                wScan.getScanSettings(scanSettings);
                String string = scanSettings.getCommandString();
                new WImportScanSettings(string);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScan.this.wScanWindow.setVisible(false);
            }
        });
    }

    public static class FileChooserActionListener
    implements ActionListener {
        public final int READ_FILE = 0;
        public final int READ_DIRECTORY = 1;
        public final int WRITE_FILE = 2;
        public final int WRITE_DIRECTORY = 3;
        public final int READ_IMAGE_FILE = 4;
        private final String title;
        private final int dialogType;
        private final int fileSelectionMode;
        private final JTextField textField;
        private final boolean preferImageFile;

        public FileChooserActionListener(String string, JTextField jTextField, int n) {
            this.title = string;
            this.textField = jTextField;
            if (n == 0) {
                this.dialogType = 0;
                this.fileSelectionMode = 0;
                this.preferImageFile = false;
            } else if (n == 1) {
                this.dialogType = 0;
                this.fileSelectionMode = 1;
                this.preferImageFile = false;
            } else if (n == 2) {
                this.dialogType = 1;
                this.fileSelectionMode = 2;
                this.preferImageFile = false;
            } else if (n == 3) {
                this.dialogType = 1;
                this.fileSelectionMode = 2;
                this.preferImageFile = false;
            } else if (n == 4) {
                this.dialogType = 0;
                this.fileSelectionMode = 0;
                this.preferImageFile = true;
            } else {
                throw new RuntimeException("Invalid mode");
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(this.title);
            jFileChooser.setDialogType(this.dialogType);
            jFileChooser.setFileSelectionMode(this.fileSelectionMode);
            jFileChooser.setSelectedFile(new File(this.textField.getText()));
            if (this.preferImageFile) {
                jFileChooser.setFileFilter(ImageFileType.imageFileFilter);
            }
            if (jFileChooser.showOpenDialog(wScan.wScanWindow) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                this.textField.setText(string);
            }
        }
    }
}

