/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.util.Observer;
import java.util.Vector;

public class UserHighlightModel {
    private byte[] highlightBytes = new byte[0];
    private boolean highlightMatchCase = true;
    private Vector<byte[]> byteVector = new Vector();
    private final ModelChangedNotifier<Object> userHighlightChangedNotifier = new ModelChangedNotifier();

    public void setHighlightBytes(byte[] byArray) {
        if (UTF8Tools.bytesMatch(byArray, this.highlightBytes)) {
            return;
        }
        this.highlightBytes = byArray;
        this.byteVector.clear();
        if (byArray.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 124 && byteArrayOutputStream.size() > 0) {
                    this.byteVector.add(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.reset();
                    continue;
                }
                byteArrayOutputStream.write(byArray[i]);
            }
            if (byteArrayOutputStream.size() > 0) {
                this.byteVector.add(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.reset();
            }
        }
        this.userHighlightChangedNotifier.fireModelChanged(null);
    }

    public byte[] getHighlightBytes() {
        return this.highlightBytes;
    }

    public Vector<byte[]> getUserHighlightByteVector() {
        return this.byteVector;
    }

    public void setHighlightMatchCase(boolean bl) {
        if (this.highlightMatchCase == bl) {
            return;
        }
        this.highlightMatchCase = bl;
        this.userHighlightChangedNotifier.fireModelChanged(null);
    }

    public boolean isHighlightMatchCase() {
        return this.highlightMatchCase;
    }

    public void addUserHighlightModelChangedListener(Observer observer) {
        this.userHighlightChangedNotifier.addObserver(observer);
    }

    public void removeUserHighlightModelChangedListener(Observer observer) {
        this.userHighlightChangedNotifier.deleteObserver(observer);
    }
}

