/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScanSettingsToolBar
extends JToolBar {
    private final JList runQueueL;
    private JButton runB;
    private JButton deleteB;
    private JButton editRedoB;
    private JButton upB;
    private JButton downB;
    private JCheckBox pauseCB;

    public ScanSettingsToolBar(JList jList) {
        super("Scan Settings Toolbar", 0);
        this.setFloatable(false);
        this.runQueueL = jList;
        this.runB = new FormedJButton(BEIcons.RUN_BULK_EXTRACTOR_24, "Generate a new report");
        this.add(this.runB);
        this.deleteB = new FormedJButton(BEIcons.DELETE_24, "Delete selection from queue");
        this.add(this.deleteB);
        this.editRedoB = new FormedJButton(BEIcons.EDIT_REDO_24, "Edit selection");
        this.add(this.editRedoB);
        this.upB = new FormedJButton(BEIcons.UP_24, "Move selection up queue to be run sooner");
        this.add(this.upB);
        this.downB = new FormedJButton(BEIcons.DOWN_24, "Move selection down queue to be run later");
        this.add(this.downB);
        this.addSeparator(new Dimension(20, 0));
        this.pauseCB = new JCheckBox("Pause");
        this.pauseCB.setToolTipText("Delay starting the next bulk_extractor run");
        this.pauseCB.setFocusable(false);
        this.pauseCB.setOpaque(false);
        this.pauseCB.setRequestFocusEnabled(false);
        this.add(this.pauseCB);
        this.setEnabledStates();
        this.wireListeners();
    }

    private void setEnabledStates() {
        this.deleteB.setEnabled(this.runQueueL.getSelectedIndex() >= 0);
        this.editRedoB.setEnabled(this.runQueueL.getSelectedIndex() >= 0);
        this.upB.setEnabled(this.runQueueL.getSelectedIndex() > 0);
        this.downB.setEnabled(this.runQueueL.getSelectedIndex() != -1 && this.runQueueL.getSelectedIndex() < BEViewer.scanSettingsListModel.getSize() - 1);
    }

    private void wireListeners() {
        this.runQueueL.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ScanSettingsToolBar.this.setEnabledStates();
                }
            }
        });
        BEViewer.scanSettingsListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                ScanSettingsToolBar.this.setEnabledStates();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                ScanSettingsToolBar.this.setEnabledStates();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                ScanSettingsToolBar.this.setEnabledStates();
            }
        });
        this.runB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScan.openWindow(new ScanSettings());
            }
        });
        this.deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = (ScanSettings)ScanSettingsToolBar.this.runQueueL.getSelectedValue();
                BEViewer.scanSettingsListModel.remove(scanSettings);
            }
        });
        this.pauseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettingsConsumer.pauseConsumer(ScanSettingsToolBar.this.pauseCB.isSelected());
            }
        });
        this.editRedoB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = (ScanSettings)ScanSettingsToolBar.this.runQueueL.getSelectedValue();
                BEViewer.scanSettingsListModel.remove(scanSettings);
                WScan.openWindow(scanSettings);
            }
        });
        this.upB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = (ScanSettings)ScanSettingsToolBar.this.runQueueL.getSelectedValue();
                BEViewer.scanSettingsListModel.moveUp(scanSettings);
            }
        });
        this.downB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = (ScanSettings)ScanSettingsToolBar.this.runQueueL.getSelectedValue();
                BEViewer.scanSettingsListModel.moveDown(scanSettings);
            }
        });
    }

    private static class FormedJButton
    extends JButton {
        FormedJButton(Icon icon, String string) {
            this.setIcon(icon);
            this.setToolTipText(string);
            this.setMinimumSize(BEViewer.BUTTON_SIZE);
            this.setPreferredSize(BEViewer.BUTTON_SIZE);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setBorderPainted(false);
        }
    }
}

