/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class ReportsPane
extends Container {
    private static final int EDGE_PADDING = 4;
    private static final long serialVersionUID = 1L;
    private JTree tree;

    public void scrollToTreePath(TreePath treePath) {
        this.tree.expandPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    public ReportsPane() {
        this.setComponents();
        BEViewer.reportsModel.getTreeSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ReportsModel.ReportTreeNode reportTreeNode = null;
                ReportsModel.FeaturesFileTreeNode featuresFileTreeNode = null;
                TreePath treePath = BEViewer.reportsModel.getSelectedTreePath();
                if (treePath != null) {
                    reportTreeNode = ReportsModel.getReportTreeNodeFromTreePath(treePath);
                    featuresFileTreeNode = ReportsModel.getFeaturesFileTreeNodeFromTreePath(treePath);
                }
                File file = reportTreeNode == null ? null : reportTreeNode.reportImageFile;
                File file2 = featuresFileTreeNode == null ? null : featuresFileTreeNode.featuresFile;
                BEViewer.reportSelectionManager.setReportSelection(file, file2);
            }
        });
    }

    public void grabTreeFocus() {
        this.tree.grabFocus();
    }

    private void setComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getReportsHeader(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.tree = new JTree();
        this.tree.setModel(BEViewer.reportsModel.getTreeModel());
        this.tree.setSelectionModel(BEViewer.reportsModel.getTreeSelectionModel());
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new ReportsTreeCellRenderer());
        this.tree.setToggleClickCount(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane jScrollPane = new JScrollPane(this.tree, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(180, 600));
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private Container getReportsHeader() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Reports"), gridBagConstraints);
        return container;
    }
}

