/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public final class NavigationPane
extends Container {
    private static final int EDGE_PADDING = 4;
    private static final int Y_PADDING = 8;
    private static final long serialVersionUID = 1L;
    private FileComponent imageFileLabel;
    private FileComponent featuresFileLabel;
    private TextComponent forensicPathLabel;
    private TextComponent featureLabel;
    private ImageComponent imageComponent;
    private JRadioButton textViewRB;
    private JRadioButton hexViewRB;
    private final ButtonGroup viewGroup = new ButtonGroup();
    private JButton reverseB;
    private JButton homeB;
    private JButton forwardB;

    public NavigationPane() {
        this.setComponents();
        this.wireActions();
    }

    public void wireActions() {
        BEViewer.featureLineSelectionManager.addFeatureLineSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
                if (!featureLine.isBlank() && !ForensicPath.isHistogram(featureLine.firstField)) {
                    NavigationPane.this.imageFileLabel.setFile(featureLine.actualImageFile);
                    NavigationPane.this.featuresFileLabel.setFile(featureLine.featuresFile);
                    NavigationPane.this.forensicPathLabel.setComponentText(ForensicPath.getPrintablePath(featureLine.forensicPath, BEViewer.imageView.getUseHexPath()));
                    NavigationPane.this.featureLabel.setComponentText(featureLine.formattedFeature);
                } else {
                    NavigationPane.this.imageFileLabel.setFile(null);
                    NavigationPane.this.featuresFileLabel.setFile(null);
                    NavigationPane.this.forensicPathLabel.setComponentText(null);
                    NavigationPane.this.featureLabel.setComponentText(null);
                }
            }
        });
        BEViewer.imageView.addImageViewChangedListener(new Observer(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void update(Observable observable, Object object) {
                ImageView.ChangeType changeType = BEViewer.imageView.getChangeType();
                if (changeType == ImageView.ChangeType.IMAGE_PAGE_CHANGED) {
                    NavigationPane.this.setPanState(BEViewer.imageView.getImagePage());
                    return;
                } else if (changeType == ImageView.ChangeType.LINE_FORMAT_CHANGED) {
                    ImageLine.LineFormat lineFormat = BEViewer.imageView.getLineFormat();
                    if (lineFormat == ImageLine.LineFormat.TEXT_FORMAT) {
                        NavigationPane.this.textViewRB.setSelected(true);
                        return;
                    } else {
                        if (lineFormat != ImageLine.LineFormat.HEX_FORMAT) throw new RuntimeException("Invalid state");
                        NavigationPane.this.hexViewRB.setSelected(true);
                    }
                    return;
                } else {
                    if (changeType != ImageView.ChangeType.FORENSIC_PATH_NUMERIC_BASE_CHANGED || BEViewer.imageView.getImagePage() == null) return;
                    ImageModel.ImagePage imagePage = BEViewer.imageView.getImagePage();
                    NavigationPane.this.forensicPathLabel.setComponentText(ForensicPath.getPrintablePath(imagePage.featureLine.forensicPath, BEViewer.imageView.getUseHexPath()));
                }
            }
        });
    }

    private void setPanState(ImageModel.ImagePage imagePage) {
        if (imagePage.pageBytes.length == 0) {
            this.homeB.setEnabled(false);
            this.reverseB.setEnabled(false);
            this.forwardB.setEnabled(false);
        } else {
            long l = ForensicPath.getOffset(imagePage.pageForensicPath);
            this.homeB.setEnabled(true);
            this.reverseB.setEnabled(l > 0L);
            this.forwardB.setEnabled(l + 65536L < imagePage.imageSize);
        }
    }

    private void setComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 8, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getFeatureStats(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        this.add((Component)new JLabel("Image"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.getImageTable(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getImageTableControls(), gridBagConstraints);
    }

    private Container getFeatureStats() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Image File"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.imageFileLabel = new FileComponent();
        container.add((Component)this.imageFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Feature File"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.featuresFileLabel = new FileComponent();
        container.add((Component)this.featuresFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Forensic Path"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.forensicPathLabel = new TextComponent();
        container.add((Component)this.forensicPathLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Feature"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.featureLabel = new TextComponent();
        container.add((Component)this.featureLabel, gridBagConstraints);
        return container;
    }

    private Component getImageTable() {
        this.imageComponent = new ImageComponent(BEViewer.imageView, BEViewer.rangeSelectionManager);
        JScrollPane jScrollPane = new JScrollPane(this.imageComponent, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(550, 600));
        return jScrollPane;
    }

    private Container getImageTableControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.textViewRB = new JRadioButton("Text");
        this.textViewRB.setFocusable(false);
        this.textViewRB.setRequestFocusEnabled(false);
        this.textViewRB.setToolTipText("Text View");
        this.viewGroup.add(this.textViewRB);
        container.add((Component)this.textViewRB, gridBagConstraints);
        this.textViewRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageView.setLineFormat(ImageLine.LineFormat.TEXT_FORMAT);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 30);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.hexViewRB = new JRadioButton("Hex");
        this.hexViewRB.setFocusable(false);
        this.hexViewRB.setRequestFocusEnabled(false);
        this.hexViewRB.setToolTipText("Hex View");
        this.viewGroup.add(this.hexViewRB);
        container.add((Component)this.hexViewRB, gridBagConstraints);
        this.hexViewRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageView.setLineFormat(ImageLine.LineFormat.HEX_FORMAT);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.reverseB = new JButton(BEIcons.REVERSE_16);
        this.reverseB.setFocusable(false);
        this.reverseB.setRequestFocusEnabled(false);
        this.reverseB.setMinimumSize(BEViewer.BUTTON_SIZE);
        this.reverseB.setPreferredSize(BEViewer.BUTTON_SIZE);
        this.reverseB.setToolTipText("Scroll Backward");
        this.reverseB.setEnabled(false);
        container.add((Component)this.reverseB, gridBagConstraints);
        this.reverseB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageModel.ImagePage imagePage = BEViewer.imageView.getImagePage();
                long l = ForensicPath.getOffset(imagePage.pageForensicPath);
                if (l >= 65536L) {
                    BEViewer.imageModel.setImageSelection(ForensicPath.getAdjustedPath(imagePage.pageForensicPath, l -= 65536L));
                } else {
                    WError.showError("Already at beginning of file.", "BEViewer Image File pan error", null);
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.homeB = new JButton(BEIcons.HOME_16);
        this.homeB.setFocusable(false);
        this.homeB.setRequestFocusEnabled(false);
        this.homeB.setMinimumSize(BEViewer.BUTTON_SIZE);
        this.homeB.setPreferredSize(BEViewer.BUTTON_SIZE);
        this.homeB.setToolTipText("Return to Start Point");
        this.homeB.setEnabled(false);
        container.add((Component)this.homeB, gridBagConstraints);
        this.homeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageModel.ImagePage imagePage = BEViewer.imageView.getImagePage();
                BEViewer.imageModel.setImageSelection(ForensicPath.getAlignedPath(imagePage.featureLine.forensicPath));
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.forwardB = new JButton(BEIcons.FORWARD_16);
        this.forwardB.setFocusable(false);
        this.forwardB.setRequestFocusEnabled(false);
        this.forwardB.setMinimumSize(BEViewer.BUTTON_SIZE);
        this.forwardB.setPreferredSize(BEViewer.BUTTON_SIZE);
        this.forwardB.setToolTipText("Scroll Forward");
        this.forwardB.setEnabled(false);
        container.add((Component)this.forwardB, gridBagConstraints);
        this.forwardB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageModel.ImagePage imagePage = BEViewer.imageView.getImagePage();
                long l = ForensicPath.getOffset(imagePage.pageForensicPath);
                long l2 = imagePage.imageSize;
                if (l + 65536L < imagePage.imageSize) {
                    BEViewer.imageModel.setImageSelection(ForensicPath.getAdjustedPath(imagePage.pageForensicPath, l += 65536L));
                } else {
                    WError.showError("Already at end of path, " + l2 + ".", "BEViewer Image File pan error", null);
                }
            }
        });
        return container;
    }
}

