/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class ImageRangePrinter
implements Printable {
    ImageView imageView = null;
    int minSelectionIndex = -1;
    int maxSelectionIndex = -1;
    ImageModel.ImagePage imagePage;
    Graphics g;
    Font textFont;
    Font monoFont;
    FontMetrics fontMetrics;
    int fontHeight;
    int ascent;
    int monospaceWidth;
    int x;
    int y;
    int linesPerPage;
    int headerSize;

    public void printImageRange(ImageView imageView, int n, int n2) {
        this.imageView = imageView;
        this.minSelectionIndex = n;
        this.maxSelectionIndex = n2;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        boolean bl = printerJob.printDialog();
        if (bl) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                WError.showError("Image range print request failed", "Print failure", printerException);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        int n3;
        this.imagePage = this.imageView.getImagePage();
        if (this.imagePage.featureLine.actualImageFile == null || this.imagePage.featureLine.featuresFile == null) {
            WError.showError("Invalid Image content", "Print Error", null);
            return 1;
        }
        this.g = graphics;
        this.textFont = new Font("serif", 0, 10);
        this.monoFont = new Font("monospaced", 0, 10);
        this.fontMetrics = graphics.getFontMetrics(this.monoFont);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        this.monospaceWidth = this.fontMetrics.stringWidth(" ");
        this.x = (int)pageFormat.getImageableX();
        this.y = (int)pageFormat.getImageableY();
        this.linesPerPage = (int)(pageFormat.getImageableHeight() / (double)this.fontHeight);
        this.headerSize = 5;
        if (n == 0) {
            n3 = this.minSelectionIndex;
            int n4 = this.maxSelectionIndex - this.minSelectionIndex + 1;
            int n5 = this.linesPerPage - this.headerSize;
            n2 = n4 > n5 ? n5 : n4;
        } else {
            int n6 = this.linesPerPage * n - this.headerSize;
            n3 = n6 + this.minSelectionIndex;
            int n7 = this.maxSelectionIndex - n3 + 1;
            int n8 = this.linesPerPage;
            int n9 = n2 = n7 > n8 ? n8 : n7;
        }
        if (n == 0) {
            this.paintHeader();
            this.paintImageLines(n3, n2);
            return 0;
        }
        if (n2 > 0) {
            this.paintImageLines(n3, n2);
            return 0;
        }
        return 1;
    }

    private void paintImageLines(int n, int n2) {
        this.g.setFont(this.monoFont);
        for (int i = 0; i < n2; ++i) {
            ImageLine imageLine = this.imageView.getLine(n + i);
            this.g.setColor(Color.YELLOW);
            for (int j = 0; j < imageLine.numHighlights; ++j) {
                int n3 = imageLine.highlightIndexes[j];
                this.g.fillRect(this.x + n3 * this.monospaceWidth, this.y, this.monospaceWidth, this.fontHeight);
            }
            this.g.setColor(Color.BLACK);
            this.g.drawString(imageLine.text, this.x, this.y + this.ascent);
            this.y += this.fontHeight;
        }
    }

    private void paintHeader() {
        this.g.setColor(Color.BLACK);
        this.g.setFont(this.textFont);
        String string = FileTools.getAbsolutePath(this.imagePage.featureLine.actualImageFile);
        String string2 = this.imagePage.featureLine.featuresFile.getAbsolutePath();
        String string3 = ForensicPath.getPrintablePath(this.imagePage.featureLine.forensicPath, this.imageView.getUseHexPath());
        this.paintPair("Image File", string);
        this.paintPair("Feature File", string2);
        this.paintPair("Forensic Path", string3);
        this.y += this.fontHeight;
    }

    private void paintPair(String string, String string2) {
        this.g.drawString(string, this.x, this.y + this.ascent);
        this.g.drawString(string2, this.x + this.monospaceWidth * 16, this.y + this.ascent);
        this.y += this.fontHeight;
    }
}

