/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class FileComponent
extends JLabel
implements MouseListener,
CopyableLineInterface {
    private static final long serialVersionUID = 1L;
    private static final String NULL_FILE = "None";
    private static final String NULL_TOOLTIP = null;
    private RangeSelectionManagerChangedListener rangeSelectionManagerChangedListener;

    public FileComponent() {
        this.setText(" ");
        this.setFile(null);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setMinimumSize(new Dimension(0, this.getPreferredSize().height));
        this.setBackground(UIManager.getColor("List.selectionBackground"));
        this.addMouseListener(this);
        this.rangeSelectionManagerChangedListener = new RangeSelectionManagerChangedListener();
        BEViewer.rangeSelectionManager.addRangeSelectionManagerChangedListener(this.rangeSelectionManagerChangedListener);
    }

    public void setFile(File file) {
        Font font = this.getFont();
        if (file == null) {
            this.setEnabled(false);
            this.setFont(font.deriveFont(2));
            this.setText(NULL_FILE);
            this.setToolTipText(NULL_TOOLTIP);
        } else {
            this.setEnabled(true);
            this.setFont(font.deriveFont(0));
            this.setText(file.getName());
            this.setToolTipText(file.getAbsolutePath());
        }
    }

    private void doSetSelectionManager() {
        this.setOpaque(true);
        this.repaint();
        BEViewer.rangeSelectionManager.setRange(this, 0, 0);
    }

    private FileComponent getThisComponent() {
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.doSetSelectionManager();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public String getCopyableLine(int n) {
        return this.getText();
    }

    private class RangeSelectionManagerChangedListener
    implements Observer {
        private RangeSelectionManagerChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (BEViewer.rangeSelectionManager.getProvider() != FileComponent.this.getThisComponent()) {
                FileComponent.this.setOpaque(false);
                FileComponent.this.repaint();
            }
        }
    }
}

