/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.SwingUtilities;

public class FeaturesParserThread
extends Thread {
    private final FeaturesModel callback;
    private final WProgress progressBar;
    private final File imageFile;
    private final File featuresFile;
    private final byte[] requestedFilterBytes;
    private final boolean filterMatchCase;
    private final boolean useHexPath;
    private boolean abortRequest = false;
    private final int PARSING_START = 0;
    private final int PARSING_TYPE_FIELD = 1;
    private final int PARSING_FEATURE_FIELD = 2;
    private final int PARSING_CONTEXT_FIELD = 3;
    private final int PARSING_DROP = 4;
    private final int PARSING_KEEP = 5;
    private final int FILTER_OFF = 0;
    private final int FILTER_ON = 1;
    private int parseState;
    private int filterState;
    private byte[] utf8Filter = null;
    private byte[] utf16Filter = null;
    private FileInputStream fileInputStream;
    private FileChannel fileChannel;
    private long fileSize;
    private byte[] bytes = new byte[65536];
    private int thisNumBytesRead;
    private int thisByteOffset;
    private long runningNumBytesRead = 0L;
    private FeatureLineTable featureLineTable;

    public FeaturesParserThread(FeaturesModel featuresModel, File file, File file2, byte[] byArray, boolean bl, boolean bl2) {
        this.featureLineTable = new FeatureLineTable(file, file2);
        this.progressBar = featuresModel.progressBar;
        this.callback = featuresModel;
        this.imageFile = file;
        this.featuresFile = file2;
        this.requestedFilterBytes = byArray;
        this.filterMatchCase = bl;
        this.useHexPath = bl2;
    }

    @Override
    public void run() {
        this.progressBar.setActive(true);
        try {
            this.parseFile();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            WError.showError("Out of memory error.  Use the text filter to create a smaller features list\nor run with more Java Heap Space, for example: 'java -Xmx1g -jar BEViewer.jar'.", "BEViewer Memory error", outOfMemoryError);
        }
        finally {
            this.progressBar.setActive(false);
            this.commitChange(this.featureLineTable);
        }
    }

    public synchronized void setAbortRequest() {
        this.abortRequest = true;
    }

    private void parseFile() {
        byte[] byArray;
        this.parseState = 0;
        this.runningNumBytesRead = 0L;
        long l = 0L;
        if (this.featuresFile == null) {
            return;
        }
        try {
            this.fileInputStream = new FileInputStream(this.featuresFile);
            byArray = new byte[]{-17, -69, -65};
            byte[] byArray2 = new byte[3];
            this.fileInputStream.read(byArray2);
            if (byArray2[0] == byArray[0] && byArray2[1] == byArray[1] && byArray2[2] == byArray[2]) {
                this.runningNumBytesRead = 3L;
            }
        }
        catch (IOException iOException) {
            if (!this.featuresFile.exists()) {
                WError.showError("Features file " + this.featuresFile + " does not exist.", "BEViewer file error", null);
            } else {
                WError.showError("Unable to open features file " + this.featuresFile + ".", "BEViewer file error", iOException);
            }
            return;
        }
        this.fileChannel = this.fileInputStream.getChannel();
        try {
            this.fileSize = this.fileChannel.size();
        }
        catch (IOException iOException) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            WError.showError("Unable to access channel in file " + this.featuresFile + ".", "BEViewer file error", iOException);
            return;
        }
        if (this.requestedFilterBytes.length == 0) {
            this.filterState = 0;
        } else {
            this.filterState = 1;
            byArray = this.filterMatchCase ? this.requestedFilterBytes : UTF8Tools.toLower(this.requestedFilterBytes);
            if (UTF8Tools.escapedLooksLikeUTF16(byArray)) {
                this.utf8Filter = UTF8Tools.utf16To8Basic(byArray);
                this.utf16Filter = byArray;
            } else {
                this.utf8Filter = byArray;
                this.utf16Filter = UTF8Tools.utf8To16Basic(byArray);
            }
        }
        while (this.runningNumBytesRead < this.fileSize) {
            if (this.abortRequest) {
                this.featureLineTable = new FeatureLineTable(null, null);
                return;
            }
            this.progressBar.setPercent((int)(this.runningNumBytesRead * 100L / this.fileSize));
            long l2 = this.fileSize - this.runningNumBytesRead;
            this.thisNumBytesRead = (int)(l2 > (long)this.bytes.length ? (long)this.bytes.length : l2);
            try {
                MappedByteBuffer mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, this.runningNumBytesRead, this.thisNumBytesRead);
                mappedByteBuffer.load();
                mappedByteBuffer.get(this.bytes, 0, this.thisNumBytesRead);
            }
            catch (Exception exception) {
                WError.showError("Unable to read file " + this.featuresFile + ".", "BEViewer file read error", exception);
                break;
            }
            this.thisByteOffset = 0;
            while (this.thisByteOffset < this.thisNumBytesRead) {
                byte by = this.bytes[this.thisByteOffset];
                if (by == 10) {
                    long l3 = this.runningNumBytesRead + (long)this.thisByteOffset;
                    if (this.parseState == 5 || this.filterState == 0 && this.parseState != 4) {
                        long l4 = l3 - l;
                        if (l4 > Integer.MAX_VALUE) {
                            throw new RuntimeException("Unexpected feature line length");
                        }
                        this.featureLineTable.put(l, (int)l4);
                    }
                    l = l3 + 1L;
                    this.parseState = 0;
                } else {
                    switch (this.parseState) {
                        case 0: {
                            if (by == 35) {
                                this.parseState = 4;
                                break;
                            }
                            if (by == 9) {
                                this.parseState = 2;
                                break;
                            }
                            this.parseState = 1;
                            break;
                        }
                        case 1: {
                            if (by != 9) break;
                            this.parseState = 2;
                            break;
                        }
                        case 2: {
                            if (by == 9) {
                                this.parseState = 3;
                                break;
                            }
                            if (this.filterState != 1) break;
                            if (!this.filterMatchCase && by >= 65 && by <= 90) {
                                by = (byte)(by + 32);
                            }
                            if (by != this.utf8Filter[0] || !this.remainderMatches(this.utf8Filter) && !this.remainderMatches(this.utf16Filter)) break;
                            this.parseState = 5;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                ++this.thisByteOffset;
            }
            this.runningNumBytesRead += (long)this.thisNumBytesRead;
        }
        try {
            this.fileInputStream.close();
            this.fileInputStream = null;
        }
        catch (IOException iOException) {
            WLog.log("FeaturesModel.parseFile unable to close fileInputStream");
        }
        try {
            this.fileChannel.close();
            this.fileChannel = null;
        }
        catch (IOException iOException) {
            WLog.log("FeaturesModel.parseFile unable to close fileChannel");
        }
    }

    private boolean remainderMatches(byte[] byArray) {
        int n = byArray.length;
        if (n + this.thisByteOffset <= this.thisNumBytesRead) {
            for (int i = 1; i < n; ++i) {
                byte by = this.bytes[this.thisByteOffset + i];
                if (!this.filterMatchCase && by >= 65 && by <= 90) {
                    by = (byte)(by + 32);
                }
                if (by == byArray[i]) continue;
                return false;
            }
            return true;
        }
        if (this.runningNumBytesRead + (long)this.thisByteOffset + (long)n > this.fileSize) {
            return false;
        }
        long l = this.runningNumBytesRead + (long)this.thisByteOffset;
        byte[] byArray2 = new byte[n];
        try {
            MappedByteBuffer mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, l, n);
            mappedByteBuffer.load();
            mappedByteBuffer.get(byArray2, 0, n);
        }
        catch (Exception exception) {
            WError.showError("Unable to read file " + this.featuresFile + ".", "BEViewer file read error", exception);
            throw new RuntimeException("File error");
        }
        for (int i = 1; i < n; ++i) {
            byte by = byArray2[i];
            if (!this.filterMatchCase && by >= 65 && by <= 90) {
                by = (byte)(by + 32);
            }
            if (by == byArray[i]) continue;
            return false;
        }
        return true;
    }

    private void commitChange(FeatureLineTable featureLineTable) {
        DoCallback doCallback = new DoCallback(this.callback, featureLineTable);
        SwingUtilities.invokeLater(doCallback);
    }

    private static class DoCallback
    implements Runnable {
        private final FeaturesModel callback;
        private final FeatureLineTable featureLineTable;

        public DoCallback(FeaturesModel featuresModel, FeatureLineTable featureLineTable) {
            this.callback = featuresModel;
            this.featureLineTable = featureLineTable;
        }

        @Override
        public void run() {
            this.callback.setFeatureLineTable(this.featureLineTable);
        }
    }
}

