/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FeatureLine {
    public final File reportImageFile;
    public final File featuresFile;
    public final long startByte;
    public final int numBytes;
    public final byte[] firstField;
    public final byte[] featureField;
    public final byte[] contextField;
    public final File actualImageFile;
    public final String forensicPath;
    public final String formattedFeature;
    private boolean isFailedInitialization;

    public FeatureLine() {
        this.reportImageFile = null;
        this.featuresFile = null;
        this.startByte = 0L;
        this.numBytes = 0;
        this.firstField = new byte[0];
        this.featureField = new byte[0];
        this.contextField = new byte[0];
        this.actualImageFile = null;
        this.forensicPath = "";
        this.formattedFeature = "";
        this.isFailedInitialization = true;
    }

    public FeatureLine(File file, File file2, long l, int n) {
        int n2;
        int n3;
        Object object;
        this.reportImageFile = file;
        this.featuresFile = file2;
        this.startByte = l;
        this.numBytes = n;
        long l2 = 0L;
        byte[] byArray = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            FileChannel fileChannel = fileInputStream.getChannel();
            l2 = fileChannel.size();
            object = fileChannel.map(FileChannel.MapMode.READ_ONLY, l, n);
            ((MappedByteBuffer)object).load();
            ((ByteBuffer)object).get(byArray, 0, n);
            fileChannel.close();
            fileInputStream.close();
            this.isFailedInitialization = false;
        }
        catch (Exception exception) {
            if (!file2.exists()) {
                WError.showErrorLater("Features file " + file2 + " does not exist.", "BEViewer file error", null);
            } else {
                WError.showErrorLater("Unable to open features file " + file2 + ".", "BEViewer file error", exception);
            }
            this.firstField = new byte[0];
            this.featureField = new byte[0];
            this.contextField = new byte[0];
            this.actualImageFile = null;
            this.forensicPath = "";
            this.formattedFeature = "";
            this.isFailedInitialization = true;
            return;
        }
        if (l + (long)n >= l2) {
            throw new RuntimeException("Invalid line request");
        }
        if (n > 0 && byArray[n - 1] == 13) {
            --n;
        }
        for (n3 = 0; n3 < n && byArray[n3] != 9; ++n3) {
        }
        object = new ByteArrayOutputStream();
        ((ByteArrayOutputStream)object).write(byArray, 0, n3);
        this.firstField = ((ByteArrayOutputStream)object).toByteArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n3 < n - 1) {
            for (n2 = n3 + 1; n2 < n && byArray[n2] != 9; ++n2) {
            }
            byteArrayOutputStream.write(byArray, n3 + 1, n2 - (n3 + 1));
        } else {
            n2 = n - 1;
            WLog.log("Malformed line: " + new String(byArray));
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        this.featureField = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        if (n2 < n - 1) {
            byteArrayOutputStream2.write(byArray, n2 + 1, n - (n2 + 1));
        }
        this.contextField = byteArrayOutputStream2.toByteArray();
        this.actualImageFile = ForensicPath.hasFilename(this.firstField) ? new File(ForensicPath.getFilename(this.firstField)) : file;
        this.forensicPath = ForensicPath.getPathWithoutFilename(this.firstField);
        this.formattedFeature = FeatureFieldFormatter.getFormattedFeatureText(file2, this.featureField, this.contextField);
    }

    public String getSummaryString() {
        String string;
        if (this.actualImageFile == null) {
            if (this.featuresFile == null) {
                return "no image file and no features file";
            }
            string = "No image file selected, " + this.firstField + ", " + this.formattedFeature;
        } else {
            string = ForensicPath.getPrintablePath(this.forensicPath, BEViewer.imageView.getUseHexPath()) + ", " + this.featuresFile.getName() + ", " + this.actualImageFile.getName() + ", " + this.formattedFeature;
        }
        if (string.length() > 200) {
            string = string.substring(0, 200) + "\u2026";
        }
        return string;
    }

    public boolean isBlank() {
        return this.reportImageFile == null && this.featuresFile == null;
    }

    public boolean isBad() {
        return this.isFailedInitialization;
    }

    public static String getSummaryString(FeatureLine featureLine) {
        return featureLine.getSummaryString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("reportImageFile: " + this.reportImageFile);
        stringBuffer.append(", actualImageFile: " + this.actualImageFile);
        stringBuffer.append(", featuresFile: " + this.featuresFile);
        stringBuffer.append(", startByte: " + this.startByte);
        stringBuffer.append(", numBytes: " + this.numBytes);
        stringBuffer.append(", firstField: " + this.firstField);
        stringBuffer.append(", forensicPath: " + this.forensicPath);
        stringBuffer.append(", featureField: " + this.featureField);
        stringBuffer.append(", contextField: " + this.contextField);
        return stringBuffer.toString();
    }

    public boolean isFromReport(ReportsModel.ReportTreeNode reportTreeNode) {
        File file = reportTreeNode.reportImageFile;
        File file2 = reportTreeNode.featuresDirectory;
        File file3 = this.featuresFile == null ? null : this.featuresFile.getParentFile();
        return FileTools.filesAreEqual(file, file) && FileTools.filesAreEqual(file2, file3);
    }

    public boolean equals(FeatureLine featureLine) {
        return FileTools.filesAreEqual(this.reportImageFile, featureLine.reportImageFile) && FileTools.filesAreEqual(this.featuresFile, featureLine.featuresFile) && this.startByte == featureLine.startByte && this.numBytes == featureLine.numBytes;
    }

    public int hashCode() {
        return (int)this.startByte;
    }
}

