/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.DefaultComboBoxModel;

public class BookmarksModel {
    public final BookmarksComboBoxModel bookmarksComboBoxModel = new BookmarksComboBoxModel();

    public void addElement(FeatureLine featureLine) {
        if (featureLine.isBlank()) {
            WLog.log("BookmarksModel.addElement blank element not added");
        } else if (this.contains(featureLine)) {
            WLog.log("BookmarksModel.addElement already has element");
        } else {
            this.bookmarksComboBoxModel.addElement(featureLine);
        }
    }

    public FeatureLine get(int n) {
        return (FeatureLine)this.bookmarksComboBoxModel.getElementAt(n);
    }

    public int size() {
        return this.bookmarksComboBoxModel.getSize();
    }

    public boolean isEmpty() {
        return this.bookmarksComboBoxModel.getSize() == 0;
    }

    public boolean contains(FeatureLine featureLine) {
        int n = this.bookmarksComboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!featureLine.equals((FeatureLine)this.bookmarksComboBoxModel.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void removeElement(FeatureLine featureLine) {
        int n = this.bookmarksComboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!featureLine.equals((FeatureLine)this.bookmarksComboBoxModel.getElementAt(i))) continue;
            this.bookmarksComboBoxModel.removeElementAt(i);
            return;
        }
        WLog.log("requested element failed to remove: " + featureLine);
    }

    public void clear() {
        this.bookmarksComboBoxModel.removeAllElements();
    }

    public FeatureLine[] getBookmarks() {
        int n = this.bookmarksComboBoxModel.getSize();
        FeatureLine[] featureLineArray = new FeatureLine[n];
        for (int i = 0; i < n; ++i) {
            featureLineArray[i] = (FeatureLine)this.bookmarksComboBoxModel.getElementAt(i);
        }
        return featureLineArray;
    }

    public void fireViewChanged() {
        this.bookmarksComboBoxModel.fireViewChanged();
    }

    public FeatureLine getSelectedItem() {
        return (FeatureLine)this.bookmarksComboBoxModel.getSelectedItem();
    }

    public void setSelectedItem(FeatureLine featureLine) {
        this.bookmarksComboBoxModel.setSelectedItem(featureLine);
    }

    public void removeAssociatedFeatureLines(ReportsModel.ReportTreeNode reportTreeNode) {
        FeatureLine[] featureLineArray = this.getBookmarks();
        int n = this.bookmarksComboBoxModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!featureLineArray[i].isFromReport(reportTreeNode)) continue;
            this.removeElement(featureLineArray[i]);
        }
    }

    public static class BookmarksComboBoxModel
    extends DefaultComboBoxModel {
        public void fireViewChanged() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

