/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicFeaturesUI
extends FeaturesUI
implements MouseListener,
MouseMotionListener {
    private FeaturesComponent featuresComponent;
    private FeaturesModel featuresModel;
    private FeaturesModelChangedListener featuresModelChangedListener;
    private RangeSelectionManager rangeSelectionManager;
    private RangeSelectionManagerChangedListener rangeSelectionManagerChangedListener;
    private UserHighlightModelChangedListener userHighlightModelChangedListener;
    private FeatureLineSelectionManagerChangedListener featureLineSelectionManagerChangedListener;
    private int mouseDownLine;
    private int selectedLine = -1;
    private FontMetrics textMetrics;
    private FontMetrics prefixMetrics;
    private boolean makingRangeSelection = false;
    private int minSelectionIndex = -1;
    private int maxSelectionIndex = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicFeaturesUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.featuresComponent = (FeaturesComponent)jComponent;
        this.featuresModel = ((FeaturesComponent)jComponent).getFeaturesModel();
        this.rangeSelectionManager = ((FeaturesComponent)jComponent).getRangeSelectionManager();
        this.rangeSelectionManagerChangedListener = new RangeSelectionManagerChangedListener();
        this.rangeSelectionManager.addRangeSelectionManagerChangedListener(this.rangeSelectionManagerChangedListener);
        this.featuresComponent.addMouseListener(this);
        this.featuresComponent.addMouseMotionListener(this);
        this.featuresModelChangedListener = new FeaturesModelChangedListener();
        this.featuresModel.addFeaturesModelChangedListener(this.featuresModelChangedListener);
        this.userHighlightModelChangedListener = new UserHighlightModelChangedListener();
        BEViewer.userHighlightModel.addUserHighlightModelChangedListener(this.userHighlightModelChangedListener);
        this.featureLineSelectionManagerChangedListener = new FeatureLineSelectionManagerChangedListener();
        BEViewer.featureLineSelectionManager.addFeatureLineSelectionManagerChangedListener(this.featureLineSelectionManagerChangedListener);
        this.setKeyboardListener();
    }

    private void setKeyboardListener() {
        this.featuresComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (BasicFeaturesUI.this.selectedLine < 0) {
                    // empty if block
                }
                if (KeyEvent.getKeyText(keyEvent.getKeyCode()) == "Up") {
                    BasicFeaturesUI.this.selectLine(BasicFeaturesUI.this.selectedLine - 1);
                } else if (KeyEvent.getKeyText(keyEvent.getKeyCode()) == "Down") {
                    BasicFeaturesUI.this.selectLine(BasicFeaturesUI.this.selectedLine + 1);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    if (BasicFeaturesUI.this.rangeSelectionManager.getProvider() == BasicFeaturesUI.this.featuresModel) {
                        BasicFeaturesUI.this.rangeSelectionManager.clear();
                        return;
                    }
                    FeaturesModel.ModelRole modelRole = BasicFeaturesUI.this.featuresModel.getModelRole();
                    if (BasicFeaturesUI.this.selectedLine != -1 && modelRole == FeaturesModel.ModelRole.HISTOGRAM_ROLE) {
                        BasicFeaturesUI.this.selectedLine = -1;
                        BEViewer.referencedFeaturesModel.setFilterBytes(new byte[0]);
                        BasicFeaturesUI.this.featuresComponent.repaint();
                    }
                }
            }
        });
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.featuresComponent.removeMouseListener(this);
        this.featuresComponent.removeMouseMotionListener(this);
        this.featuresModel.removeFeaturesModelChangedListener(this.featuresModelChangedListener);
        BEViewer.userHighlightModel.removeUserHighlightModelChangedListener(this.userHighlightModelChangedListener);
        BEViewer.featureLineSelectionManager.removeFeatureLineSelectionManagerChangedListener(this.featureLineSelectionManagerChangedListener);
        this.featuresModelChangedListener = null;
        this.userHighlightModelChangedListener = null;
        this.featureLineSelectionManagerChangedListener = null;
        this.featuresComponent = null;
        this.featuresModel = null;
        this.featuresComponent = null;
    }

    private Dimension getViewDimension() {
        int n;
        int n2;
        if (this.featuresModel.getTotalLines() == 0) {
            n2 = 0;
            n = 0;
        } else {
            int n3 = this.featuresModel.getTotalLines();
            FeatureLine featureLine = this.featuresModel.getFeatureLine(0);
            String string = ForensicPath.getPrintablePath(featureLine.forensicPath, this.featuresModel.getUseHexPath());
            FontMetrics fontMetrics = this.featuresComponent.getFontMetrics(this.getTextFont());
            n2 = fontMetrics.stringWidth("W") * (string.length() + 4 + this.featuresModel.getWidestLineLength());
            n = fontMetrics.getHeight() * n3;
        }
        return new Dimension(n2, n);
    }

    public Font getTextFont() {
        return new Font("serif", 0, this.featuresModel.getFontSize());
    }

    private Font getPrefixFont() {
        return new Font("monospaced", 0, this.featuresModel.getFontSize());
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = new Rectangle(jComponent.getPreferredSize());
        Rectangle rectangle2 = graphics.getClipBounds();
        Font font = this.getTextFont();
        Font font2 = this.getPrefixFont();
        this.textMetrics = graphics.getFontMetrics(font);
        this.prefixMetrics = graphics.getFontMetrics(font2);
        int n = this.prefixMetrics.stringWidth("w") * 8;
        int n2 = this.textMetrics.getHeight();
        int n3 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n4 = Math.max(0, n3 / n2);
        int n5 = rectangle2.y - rectangle.y;
        int n6 = Math.max(0, n5 / n2);
        int n7 = rectangle.height / n2;
        int n8 = this.textMetrics.getAscent();
        Color color = UIManager.getColor("List.selectionBackground");
        if (rectangle.height % n2 != 0) {
            ++n7;
        }
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + n6 * n2, rectangle.width, n2);
        int n9 = rectangle3.y;
        int n10 = rectangle3.x;
        int n11 = this.featuresModel.getTotalLines();
        int n12 = Math.min(n11, n7 - n4);
        if (rectangle.width > 20000 || rectangle.height > 20000) {
            graphics.setColor(UIManager.getColor("List.background"));
            graphics.fillRect(rectangle.x, rectangle.y, 20000, 20000);
        }
        for (int i = n6; i < n12; ++i) {
            FeatureLine featureLine = this.featuresModel.getFeatureLine(i);
            if (featureLine.isBad()) {
                BEViewer.reportSelectionManager.setReportSelection(null, null);
                return;
            }
            String string = ForensicPath.getPrintablePath(featureLine.forensicPath, this.featuresModel.getUseHexPath());
            int n13 = this.prefixMetrics.stringWidth(string);
            int n14 = n13 + (n - n13 % n);
            String string2 = featureLine.formattedFeature;
            char[] cArray = string2.toCharArray();
            int n15 = this.textMetrics.charsWidth(cArray, 0, cArray.length);
            if (i >= this.minSelectionIndex && i <= this.maxSelectionIndex) {
                graphics.setColor(color);
                graphics.fillRect(n10, n9, n14 + n15, n2);
            }
            if (i == this.selectedLine) {
                graphics.setColor(color.darker());
                graphics.fillRect(n10, n9, n14, n2);
            }
            graphics.setColor(Color.YELLOW);
            Vector<FeatureHighlightIndex> vector = FeatureHighlightIndex.getHighlightIndexes(cArray);
            Enumeration<FeatureHighlightIndex> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                FeatureHighlightIndex featureHighlightIndex = enumeration.nextElement();
                int n16 = featureHighlightIndex.beginIndex;
                int n17 = featureHighlightIndex.length;
                int n18 = n14 + this.textMetrics.charsWidth(cArray, 0, n16);
                int n19 = this.textMetrics.charsWidth(cArray, n16, n17);
                graphics.fillRect(n10 + n18, n9, n19, n2);
            }
            graphics.setColor(jComponent.getForeground());
            graphics.setFont(font2);
            graphics.drawString(string, n10, n9 + n8);
            graphics.setFont(font);
            graphics.drawString(string2, n10 + n14, n9 + n8);
            n9 += n2;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.featuresComponent.requestFocusInWindow();
        int n = mouseEvent.getY() / this.textMetrics.getHeight();
        this.mouseDownLine = n >= 0 && n < this.featuresModel.getTotalLines() ? n : -1;
        this.makingRangeSelection = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseDownLine != -1) {
            int n;
            int n2;
            int n3;
            if (!this.makingRangeSelection) {
                this.makingRangeSelection = true;
                this.rangeSelectionManager.setRange(this.featuresModel, this.mouseDownLine, this.mouseDownLine);
            }
            if ((n3 = mouseEvent.getY() / this.textMetrics.getHeight()) < 0) {
                n3 = 0;
            }
            if (n3 >= this.featuresModel.getTotalLines()) {
                n3 = this.featuresModel.getTotalLines() - 1;
            }
            if (this.mouseDownLine <= n3) {
                n2 = this.mouseDownLine;
                n = n3;
            } else {
                n2 = n3;
                n = this.mouseDownLine;
            }
            if (n2 != this.minSelectionIndex || n != this.maxSelectionIndex) {
                this.minSelectionIndex = n2;
                this.maxSelectionIndex = n;
                this.featuresComponent.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.makingRangeSelection) {
            this.rangeSelectionManager.setRange(this.featuresModel, this.minSelectionIndex, this.maxSelectionIndex);
        }
    }

    private void selectLine(int n) {
        if (n < 0 || n >= this.featuresModel.getTotalLines()) {
            return;
        }
        this.selectedLine = n;
        FeaturesModel.ModelRole modelRole = this.featuresModel.getModelRole();
        if (modelRole == FeaturesModel.ModelRole.FEATURES_ROLE) {
            BEViewer.featureLineSelectionManager.setFeatureLineSelection(this.featuresModel.getFeatureLine(this.selectedLine));
        } else if (modelRole == FeaturesModel.ModelRole.HISTOGRAM_ROLE) {
            byte[] byArray = this.featuresModel.getFeatureLine((int)this.selectedLine).featureField;
            BEViewer.referencedFeaturesModel.setFilterBytes(byArray);
        } else {
            throw new RuntimeException("Invalid type");
        }
        this.featuresComponent.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.rangeSelectionManager.getProvider() == this.featuresModel) {
            this.rangeSelectionManager.clear();
        }
        if (this.mouseDownLine >= 0) {
            this.selectLine(this.mouseDownLine);
        }
    }

    private int getLineWidth(FeatureLine featureLine) {
        String string = ForensicPath.getPrintablePath(featureLine.forensicPath, this.featuresModel.getUseHexPath());
        int n = this.prefixMetrics.stringWidth(string);
        int n2 = this.prefixMetrics.stringWidth("w") * 8;
        int n3 = n2 - n % n2;
        String string2 = featureLine.formattedFeature;
        int n4 = this.textMetrics.stringWidth(string2);
        return n + n3 + n4;
    }

    private int getHoveredFeatureLineIndex(int n, int n2) {
        int n3;
        int n4 = this.textMetrics.getHeight();
        int n5 = n3 = n2 < 0 ? -1 : n2 / n4;
        if (n3 >= 0 && n3 < this.featuresModel.getTotalLines()) {
            FeatureLine featureLine = this.featuresModel.getFeatureLine(n3);
            int n6 = this.getLineWidth(featureLine);
            if (n >= 0 && n < n6) {
                return n3;
            }
        }
        return -1;
    }

    private class RangeSelectionManagerChangedListener
    implements Observer {
        private RangeSelectionManagerChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (BasicFeaturesUI.this.rangeSelectionManager.getProvider() != BasicFeaturesUI.this.featuresModel) {
                BasicFeaturesUI.this.minSelectionIndex = -1;
                BasicFeaturesUI.this.maxSelectionIndex = -1;
                BasicFeaturesUI.this.featuresComponent.repaint();
            }
        }
    }

    private class FeaturesModelChangedListener
    implements Observer {
        private FeaturesModelChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            FeaturesModel.ChangeType changeType = BasicFeaturesUI.this.featuresModel.getChangeType();
            if (changeType == FeaturesModel.ChangeType.FEATURES_CHANGED) {
                if (BasicFeaturesUI.this.selectedLine >= 0 && BasicFeaturesUI.this.featuresModel.getModelRole() == FeaturesModel.ModelRole.HISTOGRAM_ROLE) {
                    BEViewer.referencedFeaturesModel.setFilterBytes(new byte[0]);
                }
                BasicFeaturesUI.this.selectedLine = -1;
                if (BasicFeaturesUI.this.rangeSelectionManager.getProvider() == BasicFeaturesUI.this.featuresModel) {
                    BEViewer.rangeSelectionManager.clear();
                }
                BasicFeaturesUI.this.featuresComponent.setComponentSize(BasicFeaturesUI.this.getViewDimension());
                BasicFeaturesUI.this.featuresComponent.revalidate();
            } else if (changeType == FeaturesModel.ChangeType.FORMAT_CHANGED) {
                BasicFeaturesUI.this.featuresComponent.setComponentSize(BasicFeaturesUI.this.getViewDimension());
                BasicFeaturesUI.this.featuresComponent.revalidate();
            }
            BasicFeaturesUI.this.featuresComponent.repaint();
        }
    }

    private class UserHighlightModelChangedListener
    implements Observer {
        private UserHighlightModelChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            BasicFeaturesUI.this.featuresComponent.repaint();
        }
    }

    private class FeatureLineSelectionManagerChangedListener
    implements Observer {
        private FeatureLineSelectionManagerChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (BasicFeaturesUI.this.selectedLine >= 0 && BasicFeaturesUI.this.featuresModel.getModelRole() == FeaturesModel.ModelRole.FEATURES_ROLE && !BasicFeaturesUI.this.featuresModel.getFeatureLine(BasicFeaturesUI.this.selectedLine).equals(BEViewer.featureLineSelectionManager.getFeatureLineSelection())) {
                BasicFeaturesUI.this.selectedLine = -1;
            }
            BasicFeaturesUI.this.featuresComponent.repaint();
        }
    }
}

