/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BEToolbar
extends JToolBar {
    private final JButton closeToolbarB = new JButton(BEIcons.CLOSE_16);
    private final JButton openReportB = new JButton(BEIcons.OPEN_REPORT_24);
    private final JButton runB = new JButton(BEIcons.RUN_BULK_EXTRACTOR_24);
    private final JButton copyB = new JButton(BEIcons.COPY_24);
    private final JButton printB = new JButton(BEIcons.PRINT_FEATURE_24);
    private final JButton addBookmarkB = new JButton(BEIcons.ADD_BOOKMARK_24);
    private final JButton manageBookmarksB = new JButton(BEIcons.MANAGE_BOOKMARKS_24);
    private final JTextField highlightTF = new JTextField();
    private final JCheckBox matchCaseCB = new JCheckBox("Match case");
    private Color defaultHighlightTFBackgroundColor = null;
    private final ModelChangedNotifier<Object> toolbarChangedNotifier = new ModelChangedNotifier();

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.toolbarChangedNotifier.fireModelChanged(null);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    public BEToolbar() {
        super("BEViewer Toolbar", 0);
        this.setFloatable(false);
        this.closeToolbarB.setFocusable(false);
        this.closeToolbarB.setOpaque(false);
        this.closeToolbarB.setBorderPainted(false);
        this.closeToolbarB.setToolTipText("Close this toolbar");
        this.closeToolbarB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEToolbar.this.setVisible(false);
            }
        });
        this.add(this.closeToolbarB);
        this.addSeparator(new Dimension(20, 0));
        this.addShortcutsControl();
        this.addSeparator(new Dimension(20, 0));
        this.addHighlightControl();
        this.setEnabledStates();
        this.wireListeners();
    }

    public void addToolbarChangedListener(Observer observer) {
        this.toolbarChangedNotifier.addObserver(observer);
    }

    public void removeToolbarChangedListener(Observer observer) {
        this.toolbarChangedNotifier.deleteObserver(observer);
    }

    private void addShortcutsControl() {
        this.openReportB.setFocusable(false);
        this.openReportB.setOpaque(false);
        this.openReportB.setBorderPainted(false);
        this.openReportB.setToolTipText("Open a report for browsing");
        this.openReportB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WOpen.openWindow();
            }
        });
        this.add(this.openReportB);
        this.runB.setFocusable(false);
        this.runB.setOpaque(false);
        this.runB.setBorderPainted(false);
        this.runB.setToolTipText("Generate a report using bulk_extractor");
        this.runB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScan.openWindow(new ScanSettings());
            }
        });
        this.add(this.runB);
        this.addBookmarkB.setFocusable(false);
        this.addBookmarkB.setOpaque(false);
        this.addBookmarkB.setBorderPainted(false);
        this.addBookmarkB.setToolTipText("Bookmark the selected feature");
        this.addBookmarkB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
                BEViewer.bookmarksModel.addElement(featureLine);
            }
        });
        this.add(this.addBookmarkB);
        this.manageBookmarksB.setFocusable(false);
        this.manageBookmarksB.setOpaque(false);
        this.manageBookmarksB.setBorderPainted(false);
        this.manageBookmarksB.setToolTipText("Manage bookmarks");
        this.manageBookmarksB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WManageBookmarks.openWindow();
            }
        });
        this.add(this.manageBookmarksB);
        this.copyB.setFocusable(false);
        this.copyB.setOpaque(false);
        this.copyB.setBorderPainted(false);
        this.copyB.setToolTipText("Copy selection to the System Clipboard");
        this.copyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RangeSelectionManager.setSystemClipboard(BEViewer.rangeSelectionManager.getSelection());
            }
        });
        this.add(this.copyB);
        this.printB.setFocusable(false);
        this.printB.setOpaque(false);
        this.printB.setBorderPainted(false);
        this.printB.setToolTipText("Print the selected range");
        this.printB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.printRange();
            }
        });
        this.add(this.printB);
    }

    private void addHighlightControl() {
        this.add(new JLabel("Highlight:"));
        this.addSeparator(new Dimension(3, 0));
        this.defaultHighlightTFBackgroundColor = this.highlightTF.getBackground();
        Dimension dimension = new Dimension(220, this.highlightTF.getPreferredSize().height);
        this.highlightTF.setMinimumSize(dimension);
        this.highlightTF.setPreferredSize(dimension);
        this.highlightTF.setMaximumSize(dimension);
        this.highlightTF.setToolTipText("Type text to highlight, type \"|\" between words to enter multiple Highlights");
        this.highlightTF.getDocument().addDocumentListener(new DocumentListener(){

            private void setHighlightString() {
                byte[] byArray = BEToolbar.this.highlightTF.getText().getBytes(UTF8Tools.UTF_8);
                BEViewer.userHighlightModel.setHighlightBytes(byArray);
                if (byArray.length > 0) {
                    BEToolbar.this.highlightTF.setBackground(Color.YELLOW);
                } else {
                    BEToolbar.this.highlightTF.setBackground(BEToolbar.this.defaultHighlightTFBackgroundColor);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setHighlightString();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setHighlightString();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setHighlightString();
            }
        });
        this.add(this.highlightTF);
        this.addSeparator(new Dimension(3, 0));
        this.matchCaseCB.setSelected(BEViewer.userHighlightModel.isHighlightMatchCase());
        this.matchCaseCB.setFocusable(false);
        this.matchCaseCB.setOpaque(false);
        this.matchCaseCB.setRequestFocusEnabled(false);
        this.matchCaseCB.setToolTipText("Match case in highlight text");
        this.matchCaseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.userHighlightModel.setHighlightMatchCase(BEToolbar.this.matchCaseCB.isSelected());
                BEToolbar.this.highlightTF.requestFocusInWindow();
            }
        });
        BEViewer.userHighlightModel.addUserHighlightModelChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                BEToolbar.this.matchCaseCB.setSelected(BEViewer.userHighlightModel.isHighlightMatchCase());
                byte[] byArray = BEToolbar.this.highlightTF.getText().getBytes(UTF8Tools.UTF_8);
                byte[] byArray2 = BEViewer.userHighlightModel.getHighlightBytes();
                if (!UTF8Tools.bytesMatch(byArray, byArray2)) {
                    BEToolbar.this.highlightTF.setText(new String(byArray2));
                }
            }
        });
        this.add(this.matchCaseCB);
    }

    private void wireListeners() {
        BEViewer.featureLineSelectionManager.addFeatureLineSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                BEToolbar.this.setEnabledStates();
            }
        });
        BEViewer.bookmarksModel.bookmarksComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                BEToolbar.this.setEnabledStates();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                BEToolbar.this.setEnabledStates();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                BEToolbar.this.setEnabledStates();
            }
        });
        BEViewer.rangeSelectionManager.addRangeSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                BEToolbar.this.setEnabledStates();
            }
        });
    }

    private void setEnabledStates() {
        FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
        this.addBookmarkB.setEnabled(!featureLine.isBlank() && !BEViewer.bookmarksModel.contains(featureLine));
        this.manageBookmarksB.setEnabled(!BEViewer.bookmarksModel.isEmpty());
        this.copyB.setEnabled(BEViewer.rangeSelectionManager.hasSelection());
        this.printB.setEnabled(BEViewer.rangeSelectionManager.hasSelection());
    }
}

