/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WTest
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final WTest wTest;
    public static String testWorkSettingsFileString;
    public static String testOutputDirectoryString;
    public static String testScanDirective;
    private JTextField testWorkSettingsFileTF = new JTextField(testWorkSettingsFileString, 50);
    private JTextField testOutputDirectoryTF = new JTextField(testOutputDirectoryString, 50);
    private JTextField testScanDirectiveTF = new JTextField(testScanDirective, 50);
    private JButton testWorkSettingsFileB = new FileChooserButton(BEViewer.getBEWindow(), "Select work settings File", 0, this.testWorkSettingsFileTF);
    private JButton testOutputDirectoryB = new FileChooserButton(BEViewer.getBEWindow(), "Select Output Directory", 1, this.testOutputDirectoryTF);
    private JCheckBox preferencesCB = new JCheckBox("Preferences");
    private JCheckBox bookmarksCB = new JCheckBox("Bookmarks");
    private JCheckBox scanCB = new JCheckBox("Scan");
    private JButton runB = new JButton("Run");
    private JButton closeB = new JButton("Close");

    public WTest() {
        this.wTest = this;
        this.buildInterface();
        this.setDefaults();
        this.pack();
        this.setLocationRelativeTo(BEViewer.getBEWindow());
        this.wireActions();
        this.setVisible(true);
    }

    private void buildInterface() {
        this.setTitle("Test Bulk Extractor");
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.getInputsContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.getTestSelectionsContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 15, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.getControlsContainer(), gridBagConstraints);
    }

    private void wireActions() {
        this.testWorkSettingsFileB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Select Work Settings File");
                jFileChooser.setDialogType(0);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setSelectedFile(new File(WTest.this.testWorkSettingsFileTF.getText()));
                if (jFileChooser.showOpenDialog(WTest.this.wTest) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    WTest.this.testWorkSettingsFileTF.setText(string);
                }
            }
        });
        this.testOutputDirectoryB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Select Output Directory");
                jFileChooser.setDialogType(0);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setSelectedFile(new File(WTest.this.testOutputDirectoryTF.getText()));
                if (jFileChooser.showOpenDialog(WTest.this.wTest) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    WTest.this.testOutputDirectoryTF.setText(string);
                }
            }
        });
        this.runB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                testWorkSettingsFileString = WTest.this.testWorkSettingsFileTF.getText();
                testOutputDirectoryString = WTest.this.testOutputDirectoryTF.getText();
                testScanDirective = WTest.this.testScanDirectiveTF.getText();
                TestThread testThread = new TestThread();
                testThread.start();
            }
        });
        this.closeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WTest.this.dispose();
            }
        });
    }

    private void setDefaults() {
        this.getRootPane().setDefaultButton(this.runB);
        this.preferencesCB.setSelected(true);
        this.bookmarksCB.setSelected(true);
        this.scanCB.setSelected(true);
    }

    private Container getInputsContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Test Work Settings File"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.testWorkSettingsFileTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.testWorkSettingsFileB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Test Output Directory"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.testOutputDirectoryTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        container.add((Component)this.testOutputDirectoryB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Test Scan Directive"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.testScanDirectiveTF, gridBagConstraints);
        return container;
    }

    private Container getTestSelectionsContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.preferencesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.bookmarksCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.scanCB, gridBagConstraints);
        return container;
    }

    private Container getControlsContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.runB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.closeB, gridBagConstraints);
        return container;
    }

    private class TestThread
    extends Thread {
        private TestThread() {
        }

        @Override
        public void run() {
            Object object;
            WLog.log("Starting tests");
            if (WTest.this.preferencesCB.isSelected()) {
                BETests.checkPreferences();
            }
            if (WTest.this.bookmarksCB.isSelected()) {
                object = new File(testWorkSettingsFileString);
                File file = new File(testOutputDirectoryString);
                BETests.makeBookmarks((File)object, file);
            }
            WLog.log("Tests will be done when scan competes.");
            if (WTest.this.scanCB.isSelected()) {
                object = new ScanSettings(testScanDirective);
                BEViewer.scanSettingsListModel.add((ScanSettings)object);
            }
        }
    }
}

