/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class WScanProgress
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final FileComponent imageFileLabel = new FileComponent();
    private final FileComponent featureDirectoryLabel = new FileComponent();
    private final JTextField commandField = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel statusL = new JLabel();
    private final JTextArea outputArea = new JTextArea();
    private final JButton cancelB = new JButton("Cancel");
    private final JButton closeB = new JButton("Close");
    private final ScanSettings scanSettings;
    private final Process process;
    private ThreadStdout threadStdout;
    private ThreadStderr threadStderr;

    public static void openWindow(ScanSettings scanSettings, Process process) {
        SwingUtilities.invokeLater(new RunnableWScanProgress(scanSettings, process));
    }

    private WScanProgress(ScanSettings scanSettings, Process process) {
        this.scanSettings = scanSettings;
        this.process = process;
        this.setLocationRelativeTo(BEViewer.getBEWindow());
        this.setClosePolicy();
        this.buildInterface();
        this.getRootPane().setDefaultButton(this.cancelB);
        this.wireActions();
        this.setStartState();
        this.pack();
        this.setVisible(true);
    }

    private void setClosePolicy() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WScanProgress.this.doClose();
            }
        });
    }

    private void setStartState() {
        this.imageFileLabel.setFile(new File(this.scanSettings.inputImage));
        this.featureDirectoryLabel.setFile(new File(this.scanSettings.outdir));
        String string = this.scanSettings.getCommandString();
        this.commandField.setText(string);
        this.commandField.setToolTipText(string);
        this.commandField.setCaretPosition(0);
        this.threadStdout = new ThreadStdout();
        this.threadStdout.start();
        this.threadStderr = new ThreadStderr();
        this.threadStderr.start();
        new ThreadDoneWaiter().start();
    }

    private void buildInterface() {
        this.setTitle("bulk_extractor Scan");
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.getFileContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        container.add((Component)this.getCommandContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.getProgressContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        container.add((Component)this.getOutputContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        container.add(this.buildControls(), gridBagConstraints);
    }

    private Component buildControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.cancelB, gridBagConstraints);
        this.closeB.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.closeB, gridBagConstraints);
        return container;
    }

    private void wireActions() {
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanProgress.this.doCancel();
            }
        });
        this.closeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanProgress.this.doClose();
            }
        });
    }

    private static boolean isAlive(Process process) {
        try {
            int n = process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    private void doCancel() {
        if (WScanProgress.isAlive(this.process)) {
            this.process.destroy();
        } else {
            WLog.log("WScanProgress.doCancel: process already canceled");
        }
    }

    private void doClose() {
        if (WScanProgress.isAlive(this.process)) {
            WError.showMessage("The bulk_extractor Scan window cannot be closed\nbecause bulk_extractor is running.", "bulk_extractor is running");
        } else {
            this.dispose();
        }
    }

    private Container getFileContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Image File"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.imageFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Feature Directory"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.featureDirectoryLabel, gridBagConstraints);
        return container;
    }

    private Container getCommandContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Command"), gridBagConstraints);
        this.commandField.setEditable(false);
        this.commandField.setMinimumSize(new Dimension(0, this.commandField.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.commandField, gridBagConstraints);
        return container;
    }

    private Container getProgressContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Progress"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.progressBar.setPreferredSize(new Dimension(80, this.progressBar.getPreferredSize().height));
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setStringPainted(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        this.progressBar.setString("0%");
        container.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.statusL, gridBagConstraints);
        return container;
    }

    private Container getOutputContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("bulk_extractor output"), gridBagConstraints);
        this.outputArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.outputArea, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(600, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        container.add((Component)jScrollPane, gridBagConstraints);
        return container;
    }

    private class ThreadStderr
    extends Thread {
        private final BufferedReader readFromStderr;

        ThreadStderr() {
            this.readFromStderr = new BufferedReader(new InputStreamReader(WScanProgress.this.process.getErrorStream()));
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.readFromStderr.readLine()) != null) {
                    SwingUtilities.invokeLater(new RunnableShowStderr(string));
                }
            }
            catch (IOException iOException) {
                WLog.log("ScanSettingsConsumer.ThreadStderr.run aborting.");
            }
        }
    }

    private class ThreadStdout
    extends Thread {
        private final BufferedReader readFromStdout;

        ThreadStdout() {
            this.readFromStdout = new BufferedReader(new InputStreamReader(WScanProgress.this.process.getInputStream()));
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.readFromStdout.readLine()) != null) {
                    SwingUtilities.invokeLater(new RunnableShowStdout(string));
                }
            }
            catch (IOException iOException) {
                WLog.log("ScanSettingsConsumer.ThreadStdout.run aborting.");
            }
        }
    }

    private static class RunnableWScanProgress
    implements Runnable {
        private final ScanSettings scanSettings;
        private final Process process;

        RunnableWScanProgress(ScanSettings scanSettings, Process process) {
            this.scanSettings = scanSettings;
            this.process = process;
        }

        @Override
        public void run() {
            new WScanProgress(this.scanSettings, this.process);
        }
    }

    private class ThreadDoneWaiter
    extends Thread {
        private ThreadDoneWaiter() {
        }

        @Override
        public void run() {
            try {
                WScanProgress.this.threadStdout.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            try {
                WScanProgress.this.threadStderr.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            try {
                WScanProgress.this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            SwingUtilities.invokeLater(new RunnableSetDoneState());
        }
    }

    private class RunnableSetDoneState
    implements Runnable {
        private RunnableSetDoneState() {
        }

        @Override
        public void run() {
            WScanProgress.this.closeB.setEnabled(true);
            WScanProgress.this.cancelB.setEnabled(false);
            int n = WScanProgress.this.process.exitValue();
            if (n == 0) {
                WScanProgress.this.statusL.setText("bulk_extractor scan completed.  Report " + new File(((WScanProgress)WScanProgress.this).scanSettings.outdir).getName() + " is ready.");
                WScanProgress.this.progressBar.setValue(100);
                WScanProgress.this.progressBar.setString("Done");
                BEViewer.reportsModel.addReport(new File(((WScanProgress)WScanProgress.this).scanSettings.outdir), new File(((WScanProgress)WScanProgress.this).scanSettings.inputImage));
            } else if (n == 143) {
                WScanProgress.this.statusL.setText("The bulk_extractor scan was canceled");
                WLog.log("bulk_extractor scan canceled");
                WScanProgress.this.progressBar.setString("Canceled");
                WError.showError("bulk_extractor Scanner canceled.\n" + WScanProgress.this.scanSettings.getCommandString(), "bulk_extractor scan canceled", null);
            } else {
                WScanProgress.this.statusL.setText("Error: bulk_extractor terminated with exit value " + n + ".  Please check command syntax.");
                WLog.log("bulk_extractor error exit value: " + n);
                WScanProgress.this.progressBar.setString("Error");
                WError.showError("bulk_extractor Scanner terminated with exit value " + n + ".  Please check command syntax:\n" + WScanProgress.this.scanSettings.getCommandString(), "bulk_extractor scan terminated", null);
            }
        }
    }

    private class RunnableShowStderr
    implements Runnable {
        private final String input;

        public RunnableShowStderr(String string) {
            this.input = string;
        }

        @Override
        public void run() {
            WLog.log("bulk_extractor scan error: '" + this.input + "'");
            WScanProgress.this.outputArea.append(this.input);
            WScanProgress.this.outputArea.append("\n");
        }
    }

    private class RunnableShowStdout
    implements Runnable {
        private final String input;

        private RunnableShowStdout(String string) {
            this.input = string;
        }

        @Override
        public void run() {
            int n = this.input.indexOf("(");
            int n2 = this.input.indexOf("%)");
            if (n > 0 && n2 > n) {
                WScanProgress.this.statusL.setText(this.input);
                String string = this.input.substring(n + 1, n2);
                try {
                    float f = Float.parseFloat(string);
                    WScanProgress.this.progressBar.setValue((int)f);
                    WScanProgress.this.progressBar.setString(Float.toString(f) + "%");
                }
                catch (NumberFormatException numberFormatException) {
                    WLog.log("WScanProgress.run: unexpected progress value '" + string + "' in stdout: " + this.input);
                }
            } else {
                WScanProgress.this.outputArea.append(this.input);
                WScanProgress.this.outputArea.append("\n");
            }
        }
    }
}

