/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WManageBookmarks
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static WManageBookmarks wBookmarks;
    private static JList bookmarkL;
    private static JButton clearB;
    private static JButton deleteB;
    private static JButton navigateB;
    private static JButton exportB;
    private static JButton closeB;

    public static void saveBookmarks() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Export Bookmarks as");
        jFileChooser.setDialogType(1);
        jFileChooser.setFileSelectionMode(2);
        if (jFileChooser.showOpenDialog(BEViewer.getBEWindow()) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!WManageBookmarks.validateTargetPath(file)) {
                return;
            }
            WManageBookmarks.startThread(file);
        }
    }

    public static void openWindow() {
        if (wBookmarks == null) {
            wBookmarks = new WManageBookmarks();
        }
        wBookmarks.setLocationRelativeTo(BEViewer.getBEWindow());
        wBookmarks.setVisible(true);
    }

    private static void closeWindow() {
        if (wBookmarks != null) {
            wBookmarks.setVisible(false);
        }
    }

    private WManageBookmarks() {
        this.buildInterface();
        this.setButtonStates();
        this.wireActions();
        this.getRootPane().setDefaultButton(exportB);
        this.pack();
    }

    private void buildInterface() {
        this.setTitle("Bookmarks");
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        container.add((Component)new JLabel("Bookmarks List"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(bookmarkL);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add(this.buildControls(), gridBagConstraints);
    }

    private Component buildControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        container.add((Component)clearB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        container.add((Component)deleteB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        container.add((Component)new JSeparator(1), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        container.add((Component)navigateB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        container.add((Component)exportB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        container.add((Component)closeB, gridBagConstraints);
        return container;
    }

    private void setButtonStates() {
        clearB.setEnabled(!BEViewer.bookmarksModel.isEmpty());
        deleteB.setEnabled(bookmarkL.getSelectedIndex() >= 0);
        navigateB.setEnabled(bookmarkL.getSelectedIndex() >= 0);
        exportB.setEnabled(!BEViewer.bookmarksModel.isEmpty());
    }

    private void wireActions() {
        bookmarkL.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    WManageBookmarks.this.setButtonStates();
                }
            }
        });
        BEViewer.bookmarksModel.bookmarksComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                WManageBookmarks.this.setButtonStates();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                WManageBookmarks.this.setButtonStates();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                WManageBookmarks.this.setButtonStates();
            }
        });
        clearB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.bookmarksModel.clear();
            }
        });
        deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.bookmarksModel.removeElement((FeatureLine)bookmarkL.getSelectedValue());
            }
        });
        navigateB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeatureLine featureLine = (FeatureLine)bookmarkL.getSelectedValue();
                if (featureLine == null) {
                    throw new NullPointerException();
                }
                BEViewer.featureLineSelectionManager.setFeatureLineSelection(featureLine);
            }
        });
        exportB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WManageBookmarks.saveBookmarks();
            }
        });
        closeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WManageBookmarks.this.setVisible(false);
            }
        });
    }

    public static Thread startThread(File file) {
        ExportBookmarksThread exportBookmarksThread = new ExportBookmarksThread(file);
        exportBookmarksThread.start();
        return exportBookmarksThread;
    }

    private static boolean validateTargetPath(File file) {
        if (file.exists()) {
            WError.showError("File '" + file + "' already exists.", "BEViewer file error", null);
            return false;
        }
        try {
            if (!file.createNewFile()) {
                WError.showError("File '" + file + "' cannot be created.", "BEViewer file error", null);
                return false;
            }
        }
        catch (IOException iOException) {
            WError.showError("File '" + file + "' cannot be created.", "BEViewer file error", iOException);
            return false;
        }
        return true;
    }

    static {
        bookmarkL = new JList(BEViewer.bookmarksModel.bookmarksComboBoxModel);
        clearB = new JButton("Clear");
        deleteB = new JButton("Delete");
        navigateB = new JButton("Navigate To");
        exportB = new JButton("Export");
        closeB = new JButton("Close");
        bookmarkL.getSelectionModel().setSelectionMode(0);
        bookmarkL.setCellRenderer(new FeatureListCellRenderer());
    }

    private static class ExportBookmarksThread
    extends Thread {
        private final ImageModel bookmarkImageModel = new ImageModel();
        private final ImageView bookmarkImageView = new ImageView();
        private final File bookmarkFile;

        public ExportBookmarksThread(File file) {
            this.bookmarkFile = file;
        }

        @Override
        public void run() {
            PrintWriter printWriter;
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.bookmarkFile)));
            }
            catch (IOException iOException) {
                WError.showError("Unable to write to new file " + this.bookmarkFile + ".", "BEViewer file error", iOException);
                return;
            }
            this.bookmarkImageView.setUseHexPath(BEViewer.imageView.getUseHexPath());
            this.bookmarkImageView.setLineFormat(BEViewer.imageView.getLineFormat());
            FeatureLine[] featureLineArray = BEViewer.bookmarksModel.getBookmarks();
            for (int i = 0; i < featureLineArray.length; ++i) {
                this.exportText(printWriter, featureLineArray[i]);
            }
            printWriter.close();
            WManageBookmarks.closeWindow();
            WLog.log("WManageBookmarks: export bookmarks done.");
        }

        private void exportText(PrintWriter printWriter, FeatureLine featureLine) {
            printWriter.println(featureLine.getSummaryString());
            this.bookmarkImageModel.setImageSelection(featureLine);
            while (this.bookmarkImageModel.isBusy()) {
                Thread.yield();
            }
            ImageModel.ImagePage imagePage = this.bookmarkImageModel.getImagePage();
            this.bookmarkImageView.setImagePage(imagePage);
            int n = this.bookmarkImageView.getNumLines();
            for (int i = 0; i < n; ++i) {
                ImageLine imageLine = this.bookmarkImageView.getLine(i);
                printWriter.println(imageLine.text);
            }
            printWriter.println();
        }
    }
}

