/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class WError {
    private static String composeAndLogError(String string, Throwable throwable) {
        String string2 = throwable == null ? string : string + "\n" + throwable.toString();
        WLog.log("Error: " + string);
        if (throwable != null) {
            WLog.logThrowable(throwable);
        }
        return string2;
    }

    private static void showDialog(String string, String string2, int n) {
        JOptionPane jOptionPane = new JOptionPane(string, n);
        JDialog jDialog = jOptionPane.createDialog(BEViewer.getBEWindow(), string2);
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
    }

    public static void showError(String string, String string2, Throwable throwable) {
        String string3 = WError.composeAndLogError(string, throwable);
        if (SwingUtilities.isEventDispatchThread()) {
            WError.showDialog(string3, string2, 0);
        } else {
            try {
                SwingUtilities.invokeAndWait(new RunnableMessage(string3, string2, 0));
            }
            catch (Exception exception) {
                WLog.log("Error: Unable to provide error message: '" + string3 + "' Title: '" + string2 + "'");
                WLog.logThrowable(exception);
            }
        }
    }

    public static void showErrorLater(String string, String string2, Throwable throwable) {
        String string3 = WError.composeAndLogError(string, throwable);
        SwingUtilities.invokeLater(new RunnableMessage(string3, string2, 0));
    }

    public static void showMessage(String string, String string2) {
        WLog.log("Note: " + string);
        if (SwingUtilities.isEventDispatchThread()) {
            WError.showDialog(string, string2, 1);
        } else {
            try {
                SwingUtilities.invokeAndWait(new RunnableMessage(string, string2, 1));
            }
            catch (Exception exception) {
                WLog.log("Error: Unable to provide message: '" + string + "' Title: '" + string2 + "'");
                WLog.logThrowable(exception);
            }
        }
    }

    public static void showMessageLater(String string, String string2) {
        WLog.log("Note: " + string);
        SwingUtilities.invokeLater(new RunnableMessage(string, string2, 1));
    }

    private static final class RunnableMessage
    implements Runnable {
        private final String message;
        private final String title;
        private final int type;

        public RunnableMessage(String string, String string2, int n) {
            this.message = string;
            this.title = string2;
            this.type = n;
        }

        @Override
        public void run() {
            WError.showDialog(this.message, this.title, this.type);
        }
    }
}

