/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ThreadsafeTreeModelManager {
    public final DefaultTreeModel treeModel;

    public ThreadsafeTreeModelManager(TreeNode treeNode) {
        this.treeModel = new DefaultTreeModel(treeNode);
    }

    public void removeNodeFromParent(final MutableTreeNode mutableTreeNode) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.treeModel.removeNodeFromParent(mutableTreeNode);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ThreadsafeTreeModelManager.this.treeModel.removeNodeFromParent(mutableTreeNode);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("unexpected event");
            }
        }
    }

    public void insertNodeInto(final MutableTreeNode mutableTreeNode, final MutableTreeNode mutableTreeNode2, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.treeModel.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ThreadsafeTreeModelManager.this.treeModel.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("unexpected event");
            }
        }
    }

    public void reload() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.treeModel.reload();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ThreadsafeTreeModelManager.this.treeModel.reload();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("unexpected event");
            }
        }
    }
}

