/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Observer;

public class ThreadReaderModel
extends Thread {
    private final BufferedReader bufferedReader;
    private final ModelChangedNotifier<String> readerModelChangedNotifier = new ModelChangedNotifier();

    public ThreadReaderModel(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
        this.start();
    }

    @Override
    public void run() {
        try {
            String string;
            while ((string = this.bufferedReader.readLine()) != null) {
                this.readerModelChangedNotifier.fireModelChanged(string);
            }
        }
        catch (IOException iOException) {
            WLog.log("ThreadReaderModel.run aborting.");
        }
    }

    public void addReaderModelChangedListener(Observer observer) {
        this.readerModelChangedNotifier.addObserver(observer);
    }

    public void removeReaderModelChangedListener(Observer observer) {
        this.readerModelChangedNotifier.deleteObserver(observer);
    }
}

