/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class TextComponent
extends JLabel
implements MouseListener,
CopyableLineInterface {
    private static final long serialVersionUID = 1L;
    private static final String NULL_TEXT = "None";
    private RangeSelectionManagerChangedListener rangeSelectionManagerChangedListener;

    public TextComponent() {
        this.setText(" ");
        this.setComponentText(null);
        this.setMinimumSize(new Dimension(0, this.getPreferredSize().height));
        this.setBackground(UIManager.getColor("List.selectionBackground"));
        this.addMouseListener(this);
        this.rangeSelectionManagerChangedListener = new RangeSelectionManagerChangedListener();
        BEViewer.rangeSelectionManager.addRangeSelectionManagerChangedListener(this.rangeSelectionManagerChangedListener);
    }

    public void setComponentText(String string) {
        Font font = this.getFont();
        if (string == null || string == "") {
            this.setEnabled(false);
            this.setFont(font.deriveFont(2));
            this.setText(NULL_TEXT);
        } else {
            this.setEnabled(true);
            this.setFont(font.deriveFont(0));
            this.setText(string);
        }
    }

    private void doSetSelectionManager() {
        this.setOpaque(true);
        this.repaint();
        BEViewer.rangeSelectionManager.setRange(this, 0, 0);
    }

    private TextComponent getThisComponent() {
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.doSetSelectionManager();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public String getCopyableLine(int n) {
        return this.getText();
    }

    private class RangeSelectionManagerChangedListener
    implements Observer {
        private RangeSelectionManagerChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (BEViewer.rangeSelectionManager.getProvider() != TextComponent.this.getThisComponent()) {
                TextComponent.this.setOpaque(false);
                TextComponent.this.repaint();
            }
        }
    }
}

