/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Observable;
import java.util.Observer;

public class ImageReader {
    private static final int DELAY = 60000;
    private Process process;
    private PrintWriter writeToProcess;
    private InputStream readFromProcess;
    ThreadReaderModel stderrThread;
    private boolean readerIsValid = true;
    String readerFailure = "";
    private File file;
    private String forensicPath;
    private long numBytes;
    private byte[] bytes = new byte[0];
    private long imageSize = 0L;
    private long totalSizeAtPath = 0L;

    public ImageReader(File file) {
        this.file = file;
        if (this.file == null) {
            throw new RuntimeException("imageReader");
        }
        String[] stringArray = new String[]{"bulk_extractor", "-p", "-http", this.file.getAbsolutePath()};
        String[] stringArray2 = new String[]{};
        WLog.log("BulkExtractorFileReader starting bulk_extractor process");
        WLog.log("BulkExtractorFileReader cmd: " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
        try {
            this.process = Runtime.getRuntime().exec(stringArray, stringArray2);
            this.writeToProcess = new PrintWriter(this.process.getOutputStream());
            this.readFromProcess = this.process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            this.stderrThread = new ThreadReaderModel(bufferedReader);
            this.stderrThread.addReaderModelChangedListener(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    String string = (String)object;
                    WLog.log("BulkExtractorFileReader error from bulk_extractor process " + ImageReader.this.process + ": " + string);
                }
            });
        }
        catch (IOException iOException) {
            this.readerIsValid = false;
            WError.showErrorLater("Unable to start the bulk_extractor reader.", "Error reading Image", iOException);
        }
    }

    public boolean isValid() {
        if (!this.readerIsValid) {
            return false;
        }
        try {
            int n = this.process.exitValue();
            WLog.log("BulkExtractorFileReader process terminated, status: " + n);
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public ImageReaderResponse read(String string, long l) {
        if (!this.readerIsValid) {
            throw new RuntimeException("bad state");
        }
        try {
            return this.doRead(string, l);
        }
        catch (Exception exception) {
            this.readerIsValid = false;
            WError.showErrorLater("Unable to read image data.", "Error reading Image", exception);
            return new ImageReaderResponse(new byte[0], 0L);
        }
    }

    private ImageReaderResponse doRead(String string, long l) throws Exception {
        Object object;
        int n;
        long l2 = l > 0L ? l - 1L : 0L;
        String string2 = "GET " + string + " HTTP/1.1";
        String string3 = "Range: bytes=0-" + l2;
        WLog.log("ImageReader GET request 1: " + string2);
        WLog.log("ImageReader Range request 2: " + string3);
        this.writeToProcess.println(string2);
        this.writeToProcess.println(string3);
        this.writeToProcess.println();
        this.writeToProcess.flush();
        String string4 = this.readLine();
        WLog.log("ImageReader length response 1: '" + string4 + "'");
        String string5 = this.readLine();
        WLog.log("ImageReader range response 2: '" + string5 + "'");
        String string6 = this.readLine();
        WLog.log("ImageReader available response 3: '" + string6 + "'");
        String string7 = this.readLine();
        WLog.log("ImageReader blank line response 4: '" + string7 + "'");
        WLog.log("BulkExtractorFileReader bulk_extractor read response 1: Content-Length: '" + string4 + "'");
        if (!string4.startsWith("Content-Length: ")) {
            WLog.log("Invalid content length line: '" + string4 + "'");
            this.readerIsValid = false;
        }
        String string8 = string4.substring("Content-Length: ".length());
        try {
            n = Integer.valueOf(string8);
        }
        catch (NumberFormatException numberFormatException) {
            WLog.log("Invalid numeric format in content length line: '" + string4 + "'");
            throw numberFormatException;
        }
        if ((long)n != l) {
            WLog.log("BulkExtractorFileReader: note: bytes requested: " + l + ", bytes read: " + n);
        }
        if (!string5.startsWith("Content-Range: bytes ")) {
            WLog.log("Invalid content range line: '" + string5 + "'");
            this.readerIsValid = false;
        }
        if (!string6.startsWith("X-Range-Available: bytes 0-")) {
            WLog.log("Invalid X-Range-Available line: '" + string6 + "'");
            this.readerIsValid = false;
        }
        String string9 = string6.substring("X-Range-Available: bytes 0-".length());
        try {
            int n2 = Integer.valueOf(string9);
            this.totalSizeAtPath = ForensicPath.getOffset(string) + (long)n2 + 1L;
        }
        catch (NumberFormatException numberFormatException) {
            this.totalSizeAtPath = 0L;
            WLog.log("Invalid numeric format in path range line: '" + string4 + "'");
            this.readerIsValid = false;
            throw numberFormatException;
        }
        if (!string7.equals("")) {
            WLog.log("Invalid blank line: '" + string7 + "'");
            this.readerIsValid = false;
        }
        this.bytes = this.readBytes(n);
        int n3 = this.readFromProcess.available();
        if (n3 != 0) {
            object = this.readBytes(n3);
            WLog.logBytes("Unexpected extra bytes in bulk_extractor read response", object);
            String string10 = new String((byte[])object);
            WLog.log("Unexpected bulk_extractor read response: " + n3 + " extra bytes: '" + string10 + "'");
            this.readerIsValid = false;
        }
        if (this.readerIsValid) {
            object = new ImageReaderResponse(this.bytes, this.totalSizeAtPath);
            return object;
        }
        return new ImageReaderResponse(new byte[0], 0L);
    }

    private String readLine() throws IOException {
        ThreadAborterTimer threadAborterTimer;
        ByteArrayOutputStream byteArrayOutputStream;
        block3: {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            threadAborterTimer = new ThreadAborterTimer(this.process, 60000);
            while (true) {
                if ((n = this.readFromProcess.read()) == -1) {
                    WLog.log("bulk_extractor stream terminated in readLine: " + n);
                    this.readerIsValid = false;
                    break block3;
                }
                if (n == 13) break;
                byteArrayOutputStream.write(n);
            }
            n = this.readFromProcess.read();
            if (n != 10) {
                WLog.log("Invalid line terminator returned from bulk_extractor: " + n);
                this.readerIsValid = false;
            }
        }
        threadAborterTimer.cancel();
        String string = byteArrayOutputStream.toString();
        return string;
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        ThreadAborterTimer threadAborterTimer = new ThreadAborterTimer(this.process, 60000);
        for (int i = 0; i < n; ++i) {
            int n2 = this.readFromProcess.read();
            if (n2 > 256) {
                WLog.log("Invalid byte returned from bulk_extractor: " + n2);
                this.readerIsValid = false;
                break;
            }
            if (n2 < 0) {
                WLog.log("bulk_extractor stream terminated by byte: " + n2);
                this.readerIsValid = false;
                break;
            }
            byArray[i] = (byte)n2;
        }
        threadAborterTimer.cancel();
        return byArray;
    }

    private void failIfMoreBytesAvailable() throws IOException {
        int n = this.readFromProcess.available();
        if (n != 0) {
            byte[] byArray = this.readBytes(n);
            WLog.logBytes("Unexpected extra bytes in bulk_extractor read response", byArray);
            String string = new String(byArray);
            WLog.log("Unexpected bulk_extractor read response: " + n + " extra bytes: '" + string + "', please see log for details");
        }
    }

    public void close() {
        int n = 0;
        try {
            this.writeToProcess.println();
            this.writeToProcess.flush();
            ThreadAborterTimer threadAborterTimer = new ThreadAborterTimer(this.process, 60000);
            n = this.process.waitFor();
            WLog.log("ImageReader closed for file " + this.file.getAbsolutePath());
            try {
                this.stderrThread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            threadAborterTimer.cancel();
        }
        catch (InterruptedException interruptedException) {
            Throwable throwable = interruptedException.getCause();
            WLog.logThrowable(interruptedException);
        }
        if (n != 0) {
            WLog.log("BulkExtractorFileReader.close: failure closing file " + this.file + ": " + n);
        }
    }

    public static class ImageReaderResponse {
        public final byte[] bytes;
        public final long totalSizeAtPath;

        ImageReaderResponse(byte[] byArray, long l) {
            this.bytes = byArray;
            this.totalSizeAtPath = l;
        }
    }
}

