/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ImageFileType {
    private static final String[] RAW_SUFFIX_ARRAY = new String[]{".raw", ".img", ".dd"};
    private static final String[] MULTIPART_SUFFIX_ARRAY = new String[]{".000", ".001", "001.vmdk"};
    private static final String[] E01_SUFFIX_ARRAY = new String[]{".E01"};
    private static final String[] AFF_SUFFIX_ARRAY = new String[]{".aff"};
    public static final ImageFileType RAW = new ImageFileType("Raw image");
    public static final ImageFileType MULTIPART = new ImageFileType("Multipart image");
    public static final ImageFileType E01 = new ImageFileType("E01 image");
    public static final ImageFileType AFF = new ImageFileType("AFF image");
    public static final ImageFileFilter imageFileFilter = new ImageFileFilter();
    private final String name;

    private ImageFileType(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    private static boolean hasSuffixType(String[] stringArray, File file) {
        String string = file.getName();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.toLowerCase().endsWith(stringArray[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static ImageFileType getImageFileType(File file) {
        if (ImageFileType.hasSuffixType(MULTIPART_SUFFIX_ARRAY, file)) {
            return MULTIPART;
        }
        if (ImageFileType.hasSuffixType(E01_SUFFIX_ARRAY, file)) {
            return E01;
        }
        if (ImageFileType.hasSuffixType(AFF_SUFFIX_ARRAY, file)) {
            return AFF;
        }
        return RAW;
    }

    private static class ImageFileFilter
    extends FileFilter {
        private ImageFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (ImageFileType.hasSuffixType(RAW_SUFFIX_ARRAY, file) || ImageFileType.hasSuffixType(E01_SUFFIX_ARRAY, file) || ImageFileType.hasSuffixType(AFF_SUFFIX_ARRAY, file) || file.getAbsolutePath().startsWith("/dev/")) {
                return true;
            }
            return ImageFileFilter.isValidFirstMultipartFile(file);
        }

        private static boolean isValidFirstMultipartFile(File file) {
            String string = file.getAbsolutePath();
            if (string.endsWith(".000")) {
                return true;
            }
            if (string.endsWith(".001")) {
                String string2 = string.substring(0, string.length() - 1) + "0";
                File file2 = new File(string2);
                return !file2.isFile();
            }
            return string.endsWith("001.vmdk");
        }

        @Override
        public String getDescription() {
            return "Image Files (" + ImageFileFilter.getSupportedImageFileTypes() + ")";
        }

        private static String getSupportedImageFileTypes() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < RAW_SUFFIX_ARRAY.length; ++n) {
                stringBuffer.append(RAW_SUFFIX_ARRAY[n] + " ");
            }
            for (n = 0; n < MULTIPART_SUFFIX_ARRAY.length; ++n) {
                stringBuffer.append(MULTIPART_SUFFIX_ARRAY[n] + " ");
            }
            for (n = 0; n < E01_SUFFIX_ARRAY.length; ++n) {
                stringBuffer.append(E01_SUFFIX_ARRAY[n] + " ");
            }
            for (n = 0; n < AFF_SUFFIX_ARRAY.length; ++n) {
                stringBuffer.append(AFF_SUFFIX_ARRAY[n] + " ");
            }
            if (!System.getProperty("os.name").startsWith("Windows")) {
                stringBuffer.append("/dev");
            }
            return stringBuffer.toString().trim();
        }
    }
}

