/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.Charset;

public final class ForensicPath {
    public static String getAdjustedPath(String string, long l) {
        int n = ForensicPath.getOffsetIndex(string);
        if (n == 0) {
            return String.valueOf(l);
        }
        String string2 = string.substring(0, n);
        String string3 = string2 + String.valueOf(l);
        return string3;
    }

    public static String getAlignedPath(String string) {
        long l = ForensicPath.getOffset(string);
        long l2 = l - l % 65536L;
        return ForensicPath.getAdjustedPath(string, l2);
    }

    public static long getOffset(String string) {
        long l;
        if (string == "") {
            return 0L;
        }
        int n = ForensicPath.getOffsetIndex(string);
        String string2 = string.substring(n);
        try {
            l = Long.parseLong(string2);
        }
        catch (Exception exception) {
            WLog.log("malformed forensic path: '" + string + "'");
            l = 0L;
        }
        return l;
    }

    private static int getForensicPathIndex(byte[] byArray) {
        for (int i = 0; i < byArray.length - 5; ++i) {
            if (byArray[i + 0] != -12 || byArray[i + 1] != -128 || byArray[i + 2] != -128 || byArray[i + 3] != -100 || byArray[i + 4] != 45) continue;
            return i + 5;
        }
        return 0;
    }

    private static int getOffsetIndex(String string) {
        int n = string.lastIndexOf(45);
        if (n == -1) {
            return 0;
        }
        return n + 1;
    }

    public static boolean hasFilename(byte[] byArray) {
        return ForensicPath.getForensicPathIndex(byArray) > 0;
    }

    public static String getFilename(byte[] byArray) {
        int n = ForensicPath.getForensicPathIndex(byArray);
        if (n == 0) {
            return "";
        }
        return new String(byArray, 0, n - 5, Charset.forName("UTF-8"));
    }

    public static String getPathWithoutFilename(byte[] byArray) {
        int n = ForensicPath.getForensicPathIndex(byArray);
        return new String(byArray, n, byArray.length - n, Charset.forName("UTF-8"));
    }

    public static String getPrintablePath(String string, boolean bl) {
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("-");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                long l = Long.parseLong(string2);
                String string3 = Long.toString(l, 16);
                stringBuffer.append(string3);
            }
            catch (Exception exception) {
                stringBuffer.append(string2);
            }
            if (i == stringArray.length - 1) continue;
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    public static boolean isHistogram(byte[] byArray) {
        if (byArray.length > 4 && byArray[0] == 110 && byArray[1] == 61) {
            int n;
            for (n = 2; n < byArray.length && byArray[n] >= 48 && byArray[n] <= 57; ++n) {
            }
            if (byArray[n] == 9) {
                return true;
            }
        }
        return false;
    }
}

