/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Vector;

public class FeatureRangePrinter
implements Printable {
    FeaturesModel featuresModel = null;
    int minSelectionIndex = -1;
    int maxSelectionIndex = -1;
    Graphics g;
    Font textFont;
    Font monoFont;
    FontMetrics textFontMetrics;
    FontMetrics monoFontMetrics;
    int monoTabWidth;
    int monoFontHeight;
    int ascent;
    int monospaceWidth;
    int x;
    int y;
    int linesPerPage;
    int headerSize;

    public void printFeatureRange(FeaturesModel featuresModel, int n, int n2) {
        this.featuresModel = featuresModel;
        this.minSelectionIndex = n;
        this.maxSelectionIndex = n2;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        boolean bl = printerJob.printDialog();
        if (bl) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                WError.showError("Feature range print request failed", "Print failure", printerException);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        int n3;
        if (this.featuresModel.getFeaturesFile() == null) {
            WError.showError("Invalid Feature content", "Print Error", null);
            return 1;
        }
        this.g = graphics;
        this.textFont = new Font("serif", 0, 10);
        this.monoFont = new Font("monospaced", 0, 10);
        this.textFontMetrics = graphics.getFontMetrics(this.textFont);
        this.monoFontMetrics = graphics.getFontMetrics(this.monoFont);
        this.monoTabWidth = this.monoFontMetrics.stringWidth(" ") * 8;
        this.monoFontMetrics = graphics.getFontMetrics(this.monoFont);
        this.monoFontHeight = this.monoFontMetrics.getHeight();
        this.ascent = this.monoFontMetrics.getAscent();
        this.monospaceWidth = this.monoFontMetrics.stringWidth(" ");
        this.x = (int)pageFormat.getImageableX();
        this.y = (int)pageFormat.getImageableY();
        this.linesPerPage = (int)(pageFormat.getImageableHeight() / (double)this.monoFontHeight);
        this.headerSize = this.featuresModel.getFilterBytes().length == 0 ? 2 : 3;
        if (n == 0) {
            n3 = this.minSelectionIndex;
            int n4 = this.maxSelectionIndex - this.minSelectionIndex + 1;
            int n5 = this.linesPerPage - this.headerSize;
            n2 = n4 > n5 ? n5 : n4;
        } else {
            int n6 = this.linesPerPage * n - this.headerSize;
            n3 = n6 + this.minSelectionIndex;
            int n7 = this.maxSelectionIndex - n3 + 1;
            int n8 = this.linesPerPage;
            int n9 = n2 = n7 > n8 ? n8 : n7;
        }
        if (n == 0) {
            this.paintHeader();
            this.paintFeatureLines(n3, n2);
            return 0;
        }
        if (n2 > 0) {
            this.paintFeatureLines(n3, n2);
            return 0;
        }
        return 1;
    }

    private void paintFeatureLines(int n, int n2) {
        this.g.setFont(this.monoFont);
        for (int i = 0; i < n2; ++i) {
            FeatureLine featureLine = this.featuresModel.getFeatureLine(n + i);
            String string = featureLine.formattedFeature;
            char[] cArray = string.toCharArray();
            String string2 = ForensicPath.getPrintablePath(featureLine.forensicPath, this.featuresModel.getUseHexPath());
            int n3 = this.monoFontMetrics.stringWidth(string2);
            int n4 = n3 + (this.monoTabWidth - n3 % this.monoTabWidth);
            this.g.setColor(Color.YELLOW);
            Vector<FeatureHighlightIndex> vector = FeatureHighlightIndex.getHighlightIndexes(cArray);
            Enumeration<FeatureHighlightIndex> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                FeatureHighlightIndex featureHighlightIndex = enumeration.nextElement();
                int n5 = featureHighlightIndex.beginIndex;
                int n6 = featureHighlightIndex.length;
                int n7 = n4 + this.textFontMetrics.charsWidth(cArray, 0, n5);
                int n8 = this.textFontMetrics.charsWidth(cArray, n5, n6);
                this.g.fillRect(this.x + n7, this.y, n8, this.monoFontHeight);
            }
            this.g.setColor(Color.BLACK);
            this.g.setFont(this.monoFont);
            this.g.drawString(string2, this.x, this.y + this.ascent);
            this.g.setFont(this.textFont);
            this.g.drawString(string, this.x + n4, this.y + this.ascent);
            this.y += this.monoFontHeight;
        }
    }

    private void paintHeader() {
        String string;
        this.g.setColor(Color.BLACK);
        this.g.setFont(this.textFont);
        if (this.featuresModel.getModelRole() == FeaturesModel.ModelRole.FEATURES_ROLE) {
            string = "Feature File";
        } else if (this.featuresModel.getModelRole() == FeaturesModel.ModelRole.HISTOGRAM_ROLE) {
            string = "Histogram File";
        } else {
            throw new RuntimeException("bad state");
        }
        String string2 = this.featuresModel.getFeaturesFile().getAbsolutePath();
        byte[] byArray = this.featuresModel.getFilterBytes();
        this.paintValues(string, string2);
        if (byArray.length > 0) {
            this.paintValues("Feature Filter", new String(byArray));
        }
        this.y += this.monoFontHeight;
    }

    private void paintValues(String string, String string2) {
        this.g.drawString(string, this.x, this.y + this.ascent);
        this.g.drawString(string2, this.x + this.monospaceWidth * 16, this.y + this.ascent);
        this.y += this.monoFontHeight;
    }
}

