/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;

public class FeatureLineTable {
    private static final int LINES_PER_GROUP = 65536;
    private final HashMap<Integer, LineGroup> lineGroups = new HashMap();
    private LineGroup activeLineGroup = null;
    private int totalLines = 0;
    private int widestLineLength = 0;
    private File imageFile;
    private File featureFile;

    public FeatureLineTable(File file, File file2) {
        this.imageFile = file;
        this.featureFile = file2;
    }

    public void put(long l, int n) {
        int n2 = this.totalLines / 65536;
        int n3 = this.totalLines % 65536;
        if (n3 == 0) {
            this.activeLineGroup = new LineGroup();
            this.lineGroups.put(new Integer(n2), this.activeLineGroup);
        }
        ((LineGroup)this.activeLineGroup).lineBeginIndex[n3] = l;
        ((LineGroup)this.activeLineGroup).lineLength[n3] = n;
        ++this.totalLines;
        if (n > this.widestLineLength) {
            this.widestLineLength = n;
        }
    }

    public FeatureLine get(int n) {
        if (n < 0 || n >= this.totalLines) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bounds.");
        }
        int n2 = n / 65536;
        int n3 = n % 65536;
        LineGroup lineGroup = this.lineGroups.get(new Integer(n2));
        long l = lineGroup.lineBeginIndex[n3];
        int n4 = lineGroup.lineLength[n3];
        return new FeatureLine(this.imageFile, this.featureFile, l, n4);
    }

    public int getWidestLineLength() {
        return this.widestLineLength;
    }

    public int size() {
        return this.totalLines;
    }

    private class LineGroup {
        private final long[] lineBeginIndex = new long[65536];
        private final int[] lineLength = new int[65536];

        private LineGroup() {
        }
    }
}

