bruteforce-luks
===============

The purpose of this program is to try to find the password of a LUKS
encrypted volume.

It can be used in two ways:

 - try all the possible passwords given a charset
 - try all the passwords in a file

There is a command line option to specify the number of threads to use.

Sending a USR1 signal to a running bruteforce-luks process makes it print
progress and continue.


## Exhaustive mode

The program tries to decrypt at least one of the key slots by trying
all the possible passwords. It is especially useful if you know
something about the password (i.e. you forgot a part of your password but still
remember most of it). Finding the password of a volume without knowing
anything about it would take way too much time (unless the password is really
short and/or weak).

There are command line options to specify:

 - the minimum password length to try
 - the maximum password length to try
 - the beginning of the password
 - the end of the password
 - the character set to use (among the characters of the current locale)


## Dictionary mode

The program tries to decrypt at least one of the key slots by trying all the
passwords contained in a file. The file must have one password per line.


## Dependencies

The program requires the cryptsetup library.


## Compilation

Install the dependencies. For example on a GNU/Linux Debian-like system, enter
the commands:

    sudo apt install dh-autoreconf
    sudo apt install libcryptsetup-dev

For Fedora, enter the commands:

    sudo dnf install dh-autoreconf
    sudo dnf install cryptsetup-devel

If you are building from the raw sources, you must first generate the
configuration script:

    ./autogen.sh


Then, build the program with the commands:

    ./configure
    make


You can run the tests to check if things work correctly with:

    make check


To install it on your system, use the command:

    make install


## Examples

Try to find the password of a LUKS encrypted volume using 4 threads, trying
only passwords with 5 characters:

    bruteforce-luks -t 4 -l 5 -m 5 /dev/sdb1


Try to find the password of a LUKS encrypted volume using 8 threads, trying
only passwords with 5 to 10 characters beginning with "W4l" and ending with "z":

    bruteforce-luks -t 8 -l 5 -m 10 -b "W4l" -e "z" /dev/sda2


Try to find the password of a LUKS encrypted volume using 8 threads, trying
only passwords with 10 characters using the character set "P情8ŭ":

    bruteforce-luks -t 8 -l 10 -m 10 -s "P情8ŭ" /dev/sdc3


Try to find the password of a LUKS encrypted volume using 6 threads, trying
the passwords contained in a dictionary file:

    bruteforce-luks -t 6 -f dictionary.txt /dev/sdd1


Instead of passing a block device to the program, you can copy the beginning
of the LUKS volume to a file and pass this file to the program:

    sudo cryptsetup luksHeaderBackup --header-backup-file /tmp/luks-header /dev/sda1
    sudo chown $USER /tmp/luks-header
    bruteforce-luks -t 4 -l 5 -m 5 /tmp/luks-header


Print progress info:

    pkill -USR1 -f bruteforce-luks


Print progress info every 30 seconds:

    bruteforce-luks -t 6 -f dictionary.txt -v 30 /dev/sdd1


Save/restore state between sessions:

    bruteforce-luks -t 6 -f dictionary.txt -w state.txt /dev/sdd1
      (Let the program run for a few minutes and stop it)
    bruteforce-luks -t 6 -w state.txt /dev/sdd1
