/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView;

import bluepot.pkgModel.Model;
import bluepot.pkgModel.ObserverMessage;
import bluepot.pkgView.Attackers.Attackers;
import bluepot.pkgView.ControlPanel.Configuration;
import bluepot.pkgView.Sensors.ConfigureSensors;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;

public class View
extends JFrame
implements Observer {
    private final Configuration configuration;
    private JTabbedPane mainTabbedPane = new JTabbedPane();
    private ImageIcon icnMonitor = new ImageIcon("icons/monitor.png");
    private ImageIcon icnPhone = new ImageIcon("icons/phone.png");
    private ImageIcon icnUp = new ImageIcon("icons/up.png");
    private ImageIcon icnDown = new ImageIcon("icons/down.png");
    private ImageIcon icnSensors = new ImageIcon("icons/plugin_edit.png");
    private ImageIcon icnCP = new ImageIcon("icons/application_edit.png");
    private ImageIcon icnAttacker = new ImageIcon("icons/user.png");
    ConfigureSensors panelConfigureSensors;
    private Model model;
    private boolean[] selectedDeviceRows;
    private final Attackers panelAttackers;

    public View(Model model) {
        super("Bluetooth Honeypot");
        Image im = Toolkit.getDefaultToolkit().getImage("icons/logo.gif");
        this.setIconImage(im);
        this.model = model;
        this.setLayout((LayoutManager)new MigLayout("wrap 1"));
        this.selectedDeviceRows = new boolean[model.getNoOfDevices()];
        for (int i = 0; i < model.getNoOfDevices(); ++i) {
            this.selectedDeviceRows[i] = false;
        }
        this.configuration = new Configuration(this, model);
        this.panelConfigureSensors = new ConfigureSensors(this, model);
        this.panelAttackers = new Attackers(model, this);
        this.mainTabbedPane.addTab("Sensors", this.icnMonitor, this.panelConfigureSensors);
        JScrollPane configurationScrollPane = new JScrollPane();
        configurationScrollPane.getViewport().setView(this.configuration);
        this.mainTabbedPane.addTab("System", this.icnCP, configurationScrollPane);
        this.mainTabbedPane.addTab("Attackers", this.icnAttacker, this.panelAttackers);
        this.mainTabbedPane.setFont(new Font("Arial", 0, 15));
        this.add((Component)this.mainTabbedPane, "w 100%, h 100%");
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(800, 600));
        this.setVisible(true);
        this.setExtendedState(this.getExtendedState() | 6);
    }

    public ImageIcon getIcnDown() {
        return this.icnDown;
    }

    public ImageIcon getIcnMonitor() {
        return this.icnMonitor;
    }

    public ImageIcon getIcnPhone() {
        return this.icnPhone;
    }

    public ImageIcon getIcnUp() {
        return this.icnUp;
    }

    public boolean[] getSelectedDeviceRows() {
        return this.selectedDeviceRows;
    }

    public void setTabTitle(int i, String s) {
        this.mainTabbedPane.setTitleAt(i, s);
    }

    public void fireMainTableDataChanged() {
        this.panelConfigureSensors.getTableModel().fireTableDataChanged();
    }

    public void addLogToDevice(int i, String s) {
        this.panelConfigureSensors.addLog(i, s);
    }

    public void setBtnSaveActionListener(ActionListener al) {
        this.panelConfigureSensors.getBtnSave().addActionListener(al);
    }

    public void setBtnResetActionListener(ActionListener al) {
        this.panelConfigureSensors.getBtnReset().addActionListener(al);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            this.panelAttackers.newAttackers();
        } else {
            ObserverMessage barg = (ObserverMessage)arg;
            this.addLogToDevice(barg.getID(), barg.getMsg());
        }
    }

    public void updateOBEXChart() {
        this.panelConfigureSensors.updateOBEXChart();
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return this.panelConfigureSensors.getLastSelectedPathComponent();
    }

    public void setCard(String string) {
        this.panelConfigureSensors.setCard(string);
    }

    public void fireSmallTableDataChanged() {
        this.panelConfigureSensors.fireSmallTableDataChanged();
    }

    public void updateSensors() {
        this.panelConfigureSensors.updateSensors();
    }
}

