/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Attackers;

import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTitledPanel;

public class Attackers
extends JPanel {
    Model model;
    View view;
    private String[] listOfAttackers;
    private JComboBox selectAttacker;
    private JTextArea txtLog;
    private boolean noAttackers = true;
    private final JPanel mnPanel;
    private final JPanel lgPanel;
    private final JXTitledPanel mainPanel;
    private final JXTitledPanel logPanel;
    private final JLabel hits;
    private final JLabel firstSeen;
    private final JLabel lastSeen;
    private final JLabel txtHits;
    private final JLabel txtFirstSeen;
    private final JLabel txtlastSeen;
    private final JPanel infoPanel;
    private final JLabel choose;
    private final JLabel none;
    private final TitledBorder infoBorder;
    private final Font smFont;
    private String lastSelected = "";
    private final JScrollPane txtScroll;

    public Attackers(Model model, View view) {
        super(new CardLayout());
        this.setLayout(new GridBagLayout());
        this.model = model;
        this.view = view;
        this.none = new JLabel("Currently no attack data.", 0);
        this.none.setVerticalAlignment(0);
        Font txtFont = new Font("Arial", 1, 25);
        this.smFont = new Font("Arial", 1, 1);
        this.none.setFont(txtFont);
        this.none.setForeground(Color.gray);
        this.add(this.none);
        this.choose = new JLabel("Choose an attacker: ");
        this.mnPanel = new JPanel((LayoutManager)new MigLayout("wrap 2"));
        this.lgPanel = new JPanel((LayoutManager)new MigLayout("wrap 1"));
        this.mainPanel = new JXTitledPanel("Attacker", (Container)this.mnPanel);
        this.logPanel = new JXTitledPanel("Log", (Container)this.lgPanel);
        this.hits = new JLabel("Hits: ");
        this.firstSeen = new JLabel("First Seen: ");
        this.lastSeen = new JLabel("Last Seen: ");
        this.txtHits = new JLabel("0");
        this.txtFirstSeen = new JLabel("-");
        this.txtlastSeen = new JLabel("-");
        this.infoPanel = new JPanel((LayoutManager)new MigLayout("wrap 2"));
        this.selectAttacker = new JComboBox();
        this.selectAttacker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Attackers.this.selectAttacker.getItemCount() > 0) {
                    Attackers.this.setTextBox(Attackers.this.selectAttacker.getSelectedItem().toString());
                }
            }
        });
        this.txtScroll = new JScrollPane();
        this.txtLog = new JTextArea();
        this.txtLog.setEditable(false);
        this.txtLog.setBackground(Color.white);
        this.txtLog.setEditable(false);
        this.txtLog.setForeground(Color.black);
        this.txtLog.setAutoscrolls(true);
        this.txtLog.setDragEnabled(false);
        this.txtScroll.getViewport().setView(this.txtLog);
        this.infoBorder = new TitledBorder("Information");
    }

    public void startPanel() {
        this.none.setVisible(false);
        this.none.setFont(this.smFont);
        this.setLayout((LayoutManager)new MigLayout("wrap 1"));
        this.listOfAttackers = this.model.getAttackerList().keySet().toArray(new String[this.model.getAttackerList().keySet().size()]);
        this.infoPanel.add(this.hits);
        this.infoPanel.add(this.txtHits);
        this.infoPanel.setBorder(this.infoBorder);
        this.mnPanel.add(this.choose);
        this.mnPanel.add(this.selectAttacker);
        this.mnPanel.add((Component)this.infoPanel, "span 2");
        this.lgPanel.add((Component)this.txtScroll, "w 100%, h 100%");
        this.add((Component)this.mainPanel, "w 100%, h 30%");
        this.add((Component)this.logPanel, "w 100%, h 70%");
    }

    public void newAttackers() {
        if (this.noAttackers) {
            this.noAttackers = false;
            this.startPanel();
        }
        this.listOfAttackers = this.model.getAttackerList().keySet().toArray(new String[this.model.getAttackerList().keySet().size()]);
        this.selectAttacker.removeAllItems();
        for (int i = 0; i < this.listOfAttackers.length; ++i) {
            this.selectAttacker.addItem(this.listOfAttackers[i]);
        }
        this.setTextBox(this.selectAttacker.getSelectedItem().toString());
    }

    public void setTextBox(String attacker) {
        this.txtLog.setText("");
        Stack tmp = (Stack)this.model.getAttackerList().get(attacker);
        Stack cloned = (Stack)tmp.clone();
        int size = Integer.parseInt(this.txtHits.getText());
        this.txtHits.setText(Integer.toString(cloned.size()));
        while (!cloned.empty()) {
            this.txtLog.setText((String)cloned.pop() + "\n\r" + this.txtLog.getText());
        }
    }
}

