/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel.Modules;

import bluepot.pkgModel.AttackData.AttackConnect;
import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.AttackData.RFCOMM.AttackCommand;
import bluepot.pkgModel.Model;
import bluepot.pkgModel.Modules.L2CAPServer;
import bluepot.pkgModel.ObserverMessage;
import com.intel.bluetooth.BlueCoveImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class RFCOMMServer
extends Observable
implements Runnable {
    private String SERVER_NAME;
    private UUID HEADSET_PROFILE = new UUID(788L);
    private StreamConnectionNotifier serverConnection;
    private boolean isStopped = false;
    private int id;
    private Object dongleID;
    private Model model;
    private AttackModule attackModule;
    private boolean running = false;
    private Process specialBluetoothDaemon;

    public boolean isRunning() {
        return this.running;
    }

    private StreamConnectionNotifier keepOpeningConnection(String url) {
        StreamConnectionNotifier connection;
        try {
            connection = (StreamConnectionNotifier)Connector.open((String)url);
        }
        catch (ServiceRegistrationException ex) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex1);
            }
            connection = this.keepOpeningConnection(url);
        }
        catch (IOException ex) {
            System.out.println("serious error - ");
            ex.toString();
            return null;
        }
        return connection;
    }

    public RFCOMMServer(Model model, int id, Object dongleID, AttackModule attackModule) {
        this.id = id;
        this.dongleID = dongleID;
        this.model = model;
        this.attackModule = attackModule;
    }

    @Override
    public void run() {
        try {
            Process process = new ProcessBuilder("systemctl", "stop", "bluetooth").start();
            process.waitFor();
            this.specialBluetoothDaemon = new ProcessBuilder("bluetoothd", "-C", "--noplugin=sap").start();
        }
        catch (IOException ex) {
            System.out.println("failed to deal with bluetoothd - ");
            System.out.println(ex.toString());
        }
        catch (InterruptedException ex) {
            System.out.println("failed to deal with bluetoothd - ");
            System.out.println(ex.toString());
        }
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[RFCOMM] Server starting.."));
        String url = "btspp://localhost:" + this.HEADSET_PROFILE + ";name=Server";
        this.serverConnection = this.keepOpeningConnection(url);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[RFCOMM] Server started"));
        this.running = true;
        while (!this.isStopped) {
            try {
                String line;
                StreamConnection con = this.serverConnection.acceptAndOpen();
                OutputStream os = con.openOutputStream();
                InputStream is = con.openInputStream();
                this.setChanged();
                this.notifyObservers(new ObserverMessage(this.id, "[RFCOMM] Received connection from: " + RemoteDevice.getRemoteDevice((Connection)con).toString()));
                this.attackModule.addTo("connect", new AttackConnect(Calendar.getInstance().getTime(), RemoteDevice.getRemoteDevice((Connection)con).toString()));
                this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)con).toString(), "[Device " + this.id + "] Connected on RFCOMM");
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                int count = 0;
                while ((line = reader.readLine()) != null && ++count < 50) {
                    if (line.equals("AT+GMI")) {
                        os.write(new String(this.model.getSettings().getRespID() + "\r\n").getBytes());
                    } else if (line.equals("AT+GMM")) {
                        os.write(new String(this.model.getSettings().getRespPhone() + "\r\n").getBytes());
                    } else if (line.equals("AT+GMR")) {
                        os.write(new String(this.model.getSettings().getRespSMS() + "\r\n").getBytes());
                    } else if (line.equals("AT+CGSN")) {
                        os.write(new String("psn\r\n").getBytes());
                    } else if (line.equals("AT+GCAP")) {
                        os.write(new String("Model\r\n").getBytes());
                    } else if (line.equals("AT+CPBS=?")) {
                        os.write(new String("+CPBS=Tom,000000002\r\n").getBytes());
                    } else if (line.equals("AT+CMGF=1")) {
                        os.write(new String("+CPMS=Hi\r\n").getBytes());
                    } else {
                        os.write(new String("garbage\r\n").getBytes());
                    }
                    os.write(new String("OK\r\n").getBytes());
                    this.setChanged();
                    this.notifyObservers(new ObserverMessage(this.id, "[RFCOMM] Received command: '" + line + "' from: " + RemoteDevice.getRemoteDevice((Connection)con).toString()));
                    this.attackModule.addTo("command", new AttackCommand(Calendar.getInstance().getTime(), line, RemoteDevice.getRemoteDevice((Connection)con).toString()));
                    this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)con).toString(), "[Device " + this.id + "] Received command: '" + line + "'");
                }
                count = 0;
                os.close();
                is.close();
                con.close();
            }
            catch (IOException ex) {
                this.setChanged();
                this.notifyObservers(new ObserverMessage(this.id, "[RFCOMM] Connected client timed out"));
            }
        }
    }
}

