/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel.Modules;

import bluepot.pkgModel.AttackData.AttackConnect;
import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.AttackData.L2CAP.AttackCommand;
import bluepot.pkgModel.Model;
import bluepot.pkgModel.ObserverMessage;
import com.intel.bluetooth.BlueCoveImpl;
import java.io.IOException;
import java.util.Calendar;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

public class L2CAPServer
extends Observable
implements Runnable {
    private int id;
    private Object dongleID;
    private Model model;
    private AttackModule attackModule;
    private boolean running = false;
    private int failCount = 0;
    private boolean isStopped = false;

    public boolean isRunning() {
        return this.running;
    }

    public L2CAPServer(Model model, int id, Object dongleID, AttackModule attackModule) {
        this.id = id;
        this.dongleID = dongleID;
        this.model = model;
        this.attackModule = attackModule;
    }

    private Connection keepOpeningConnection(String url) {
        Connection connection;
        try {
            connection = Connector.open((String)url);
        }
        catch (ServiceRegistrationException ex) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex1);
            }
            connection = this.keepOpeningConnection(url);
        }
        catch (IOException ex) {
            System.out.println("serious error");
            return null;
        }
        return connection;
    }

    @Override
    public void run() {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[L2CAP] Server starting.."));
        UUID L2CAP = new UUID(256L);
        String url = "btl2cap://localhost:" + L2CAP;
        L2CAPConnectionNotifier service = null;
        service = (L2CAPConnectionNotifier)this.keepOpeningConnection(url);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[L2CAP] Server started"));
        this.running = true;
        while (!this.isStopped) {
            L2CAPConnection con = null;
            String attacker = "";
            try {
                con = service.acceptAndOpen();
                attacker = RemoteDevice.getRemoteDevice((Connection)con).toString();
                this.setChanged();
                this.notifyObservers(new ObserverMessage(this.id, "[L2CAP] Received connection from " + attacker));
                this.attackModule.addTo("connect", new AttackConnect(Calendar.getInstance().getTime(), attacker));
                this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)con).toString(), "[Device " + this.id + "] Received connection from " + attacker);
                byte[] buffer = new byte[80];
                int bytesread = 0;
                bytesread = con.receive(buffer);
                String received = new String(buffer, 0, bytesread);
                this.attackModule.addTo("connect", new AttackCommand(Calendar.getInstance().getTime(), attacker, received));
                this.model.addAttack(RemoteDevice.getRemoteDevice((Connection)con).toString(), "[Device " + this.id + "] Received command: " + received);
                con.close();
            }
            catch (IOException ex) {
                this.setChanged();
                if (this.failCount > 10) {
                    this.isStopped = true;
                    this.notifyObservers(new ObserverMessage(this.id, "[LCAP] Failed to accept connection from remote user after 10 attempts. Something is wrong with this device."));
                    continue;
                }
                ++this.failCount;
                this.notifyObservers(new ObserverMessage(this.id, "[LCAP] Failed to accept connection from remote user, trying again."));
            }
        }
    }
}

