/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Set;

public class DeviceClass {
    private static HashMap<String, BiMap> majorToMinor = new HashMap();
    private static BiMap<String, Integer> major = HashBiMap.create();
    private static BiMap<String, Integer> computer = HashBiMap.create();
    private static BiMap<String, Integer> phone = HashBiMap.create();
    private static BiMap<String, Integer> network = HashBiMap.create();
    private static BiMap<String, Integer> audiovideo = HashBiMap.create();
    private static BiMap<String, Integer> peripheral = HashBiMap.create();
    private static BiMap<String, Integer> imaging = HashBiMap.create();
    private static BiMap<String, Integer> wearable = HashBiMap.create();
    private static BiMap<String, Integer> toy = HashBiMap.create();
    private static BiMap<String, Integer> health = HashBiMap.create();
    private static BiMap<String, Integer> misc = HashBiMap.create();
    private static BiMap<String, Integer> uncategorized = HashBiMap.create();
    private String[][] majorMinorClasses;

    public DeviceClass() {
        major.put((Object)"Misc", (Object)0);
        major.put((Object)"Computer", (Object)256);
        major.put((Object)"Phone", (Object)512);
        major.put((Object)"Network", (Object)768);
        major.put((Object)"Audio/Video", (Object)1024);
        major.put((Object)"Peripheral", (Object)1280);
        major.put((Object)"Imaging", (Object)1536);
        major.put((Object)"Wearable", (Object)1792);
        major.put((Object)"Toy", (Object)2048);
        major.put((Object)"Health", (Object)2304);
        misc.put((Object)"Misc", (Object)0);
        computer.put((Object)"Uncategorized", (Object)0);
        computer.put((Object)"Desktop", (Object)4);
        computer.put((Object)"Server", (Object)8);
        computer.put((Object)"Laptop", (Object)12);
        computer.put((Object)"Handheld", (Object)16);
        computer.put((Object)"Palm", (Object)20);
        computer.put((Object)"Wearable", (Object)24);
        phone.put((Object)"Uncategorized", (Object)0);
        phone.put((Object)"Cellular", (Object)4);
        phone.put((Object)"Cordless", (Object)8);
        phone.put((Object)"Smartphone", (Object)12);
        phone.put((Object)"Modem", (Object)16);
        phone.put((Object)"ISDN", (Object)20);
        network.put((Object)"Full Available", (Object)0);
        network.put((Object)"1 - 17% utilized", (Object)32);
        network.put((Object)"17 - 33% utilized", (Object)64);
        network.put((Object)"33 - 50% utilized", (Object)96);
        network.put((Object)"50 - 67% utilized", (Object)128);
        network.put((Object)"67 - 83% utilized", (Object)160);
        network.put((Object)"83 - 99% utilized", (Object)192);
        network.put((Object)"No service available", (Object)224);
        audiovideo.put((Object)"Uncategorized", (Object)0);
        audiovideo.put((Object)"Wearable", (Object)4);
        audiovideo.put((Object)"Hands-free", (Object)8);
        audiovideo.put((Object)"Microphone", (Object)16);
        audiovideo.put((Object)"Loudspeaker", (Object)20);
        audiovideo.put((Object)"Headphones", (Object)24);
        audiovideo.put((Object)"Portable Audio", (Object)28);
        audiovideo.put((Object)"Car Audio", (Object)32);
        audiovideo.put((Object)"Set-top Box", (Object)36);
        audiovideo.put((Object)"HiFi Audio Device", (Object)40);
        audiovideo.put((Object)"VCR", (Object)44);
        audiovideo.put((Object)"Video Camera", (Object)48);
        audiovideo.put((Object)"Camcorder", (Object)52);
        audiovideo.put((Object)"Video Monitor", (Object)56);
        audiovideo.put((Object)"Video Display and Loudspeaker", (Object)60);
        audiovideo.put((Object)"Video Conferencing", (Object)64);
        audiovideo.put((Object)"Gaming/Toy", (Object)72);
        peripheral.put((Object)"Keyboard - Uncategorized", (Object)0);
        peripheral.put((Object)"Keyboard - Joystick", (Object)4);
        peripheral.put((Object)"Keyboard - Gamepad", (Object)8);
        peripheral.put((Object)"Keyboard - Remote Control", (Object)12);
        peripheral.put((Object)"Keyboard - Sensing Device", (Object)16);
        peripheral.put((Object)"Keyboard - Digitizer Tablet", (Object)20);
        peripheral.put((Object)"Keyboard - Card Reader", (Object)24);
        peripheral.put((Object)"Pointing Device - Uncategorized", (Object)28);
        imaging.put((Object)"Display", (Object)16);
        imaging.put((Object)"Camera", (Object)32);
        imaging.put((Object)"Scanner", (Object)54);
        imaging.put((Object)"Printer", (Object)128);
        wearable.put((Object)"Wrist Watch", (Object)4);
        wearable.put((Object)"Pager", (Object)8);
        wearable.put((Object)"Jacket", (Object)12);
        wearable.put((Object)"Helmet", (Object)16);
        wearable.put((Object)"Glasses", (Object)20);
        toy.put((Object)"Robot", (Object)4);
        toy.put((Object)"Vehicle", (Object)8);
        toy.put((Object)"Doll / Action Figure", (Object)12);
        toy.put((Object)"Controller", (Object)16);
        toy.put((Object)"Game", (Object)20);
        health.put((Object)"Undefined", (Object)0);
        health.put((Object)"Blood Pressure Monitor", (Object)4);
        health.put((Object)"Thermometer", (Object)8);
        health.put((Object)"Weighing Scale", (Object)12);
        health.put((Object)"Glucose Meter", (Object)16);
        health.put((Object)"Pulse Oximeter", (Object)20);
        health.put((Object)"Heart/Pulse Rate Monitor", (Object)24);
        health.put((Object)"Health Data Display", (Object)28);
        majorToMinor.put("Computer", computer);
        majorToMinor.put("Phone", phone);
        majorToMinor.put("Network", network);
        majorToMinor.put("Audio/Video", audiovideo);
        majorToMinor.put("Peripheral", peripheral);
        majorToMinor.put("Imaging", imaging);
        majorToMinor.put("Wearable", wearable);
        majorToMinor.put("Toy", toy);
        majorToMinor.put("Health", health);
        majorToMinor.put("Misc", misc);
    }

    public String minorIntToString(int ma, int mi) {
        String majorString = (String)major.inverse().get((Object)ma);
        BiMap majorMap = majorToMinor.get(majorString);
        return (String)majorMap.inverse().get((Object)mi);
    }

    public String majorIntToString(int ma) {
        return (String)major.inverse().get((Object)ma);
    }

    public int getMajorInt(String s) {
        return Integer.parseInt(((Integer)major.get((Object)s)).toString());
    }

    public int getMinorInt(String ma, String mi) {
        BiMap tmp = majorToMinor.get(ma);
        return Integer.parseInt(tmp.get((Object)mi).toString());
    }

    public String[] getMinorList(String majorClass) {
        BiMap minor = majorToMinor.get(majorClass);
        Set tmp = minor.keySet();
        Object[] a = tmp.toArray();
        String[] rtn = new String[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            rtn[i] = (String)a[i];
        }
        return rtn;
    }

    public String[] getMajorList() {
        Set tmp = major.keySet();
        Object[] a = tmp.toArray();
        String[] rtn = new String[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            rtn[i] = (String)a[i];
        }
        return rtn;
    }
}

