/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgController;

import bluepot.pkgModel.Config.Settings;
import bluepot.pkgModel.Model;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Level;

public class EmailFile {
    String filename;
    Settings settings;
    private Session session;
    Model model;

    public EmailFile(Model model) {
        this.model = model;
    }

    public void sendEmail(String filename, Settings settings) {
        this.settings = settings;
        this.filename = filename;
        String host = settings.getSmtpHost();
        String port = Integer.toString(settings.getSmtpPort());
        String from = settings.getEmailFrom();
        String to = settings.getEmailTo();
        String subject = settings.getEmailSubject();
        String msgText1 = "";
        String username = settings.getSmtpUser();
        String password = settings.getSmtpPassword();
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        if (username.isEmpty()) {
            props.put("mail.smtp.auth", "false");
            this.session = Session.getDefaultInstance((Properties)props);
        } else {
            props.put("mail.smtp.auth", "true");
            SMTPAuthenticator auth = new SMTPAuthenticator();
            this.session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        }
        MimeMessage msg = new MimeMessage(this.session);
        this.session.setDebug(false);
        try {
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(subject);
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(msgText1);
            MimeBodyPart mbp2 = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(filename);
            mbp2.setDataHandler(new DataHandler((DataSource)fds));
            mbp2.setFileName(fds.getName());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            mp.addBodyPart((BodyPart)mbp2);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException ex) {
            this.model.log(Level.ERROR, "Error sending email, probably a configuration error: " + ex.toString());
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            String username = EmailFile.this.settings.getSmtpUser();
            String password = new String(EmailFile.this.settings.getSmtpPassword());
            return new PasswordAuthentication(username, password);
        }
    }
}

