/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgController;

import bluepot.pkgController.GraphUpdater;
import bluepot.pkgController.Randomiser;
import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Level;

public class Controller {
    private View view;
    private Model model;
    private GraphUpdater graphUpdater;
    private final Randomiser randomiser;

    public Controller(Model model, View view) {
        this.view = view;
        this.model = model;
        model.log(Level.ALL, "Starting system..");
        view.setBtnSaveActionListener(new SaveSettingsActionListener());
        view.setBtnResetActionListener(new ResetActionListener());
        this.graphUpdater = new GraphUpdater(view, model);
        new Thread(this.graphUpdater).start();
        this.randomiser = new Randomiser(model, view);
        new Thread(this.randomiser).start();
        model.startServers(view);
        model.addObserver(view);
    }

    public class ResetActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.model.resetTableData();
        }
    }

    public class SaveSettingsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            Controller.this.model.applyTableData();
            Controller.this.view.updateSensors();
        }
    }
}

