export declare type State = {
    [key: string]: string | number | CustomTemplate | undefined;
};
export declare type ResolvedState = {
    [key: string]: string | number;
};
export declare type Props = {
    [key: string]: any;
};
export declare type ChangedValues = string[];
export declare type CustomTemplate = (state: ResolvedState, prebuilt: string) => string;
export declare type Config = {
    onRead: (key: string, props: Props) => any;
    onRender: (state: State, props: Props, changedValues: ChangedValues) => void;
    aliasMap?: {
        [key: string]: string;
    };
    useCache?: boolean;
    uncachedValues?: Set<string>;
};
export interface Styler {
    get: (key: string, forceRead?: boolean) => any;
    set: (key: string | State, value?: any) => Styler;
    render: (forceRender?: boolean) => Styler;
}
