'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require('react-dom');

var _reactMotion = require('react-motion');

var _Pager = require('./Pager');

var _Pager2 = _interopRequireDefault(_Pager);

var _Swipe = require('./Swipe');

var _Swipe2 = _interopRequireDefault(_Swipe);

var _Keyboard = require('./Keyboard');

var _Keyboard2 = _interopRequireDefault(_Keyboard);

var _specialAssign = require('./special-assign');

var _specialAssign2 = _interopRequireDefault(_specialAssign);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var checkedProps = {
  tag: _propTypes2.default.any,
  autoSize: _propTypes2.default.oneOf([true, false, 'width', 'height']),
  accessibility: _propTypes2.default.bool,
  springConfig: _propTypes2.default.objectOf(_propTypes2.default.number)
};

var Frame = function (_Component) {
  _inherits(Frame, _Component);

  function Frame(props) {
    _classCallCheck(this, Frame);

    var _this = _possibleConstructorReturn(this, (Frame.__proto__ || Object.getPrototypeOf(Frame)).call(this, props));

    _this._setFrameSize = function () {
      var frameSize = _this.context.pager.getFrameSize({ fullSize: true });

      if (frameSize.width && frameSize.height) {
        _this.setState(frameSize, function () {
          // we need to unset the instant flag now that React Motion has dimensions to animate to
          if (_this.state.instant) {
            _this.setState({ instant: false });
          }
        });
      }
    };

    _this.state = {
      width: 0,
      height: 0,
      instant: true
    };
    _this._hydrate = false;
    return _this;
  }

  _createClass(Frame, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      var pager = this.context.pager;
      var _props = this.props,
          autoSize = _props.autoSize,
          accessibility = _props.accessibility;


      pager.setOptions({ autoSize: autoSize, accessibility: accessibility });

      this._swipe = new _Swipe2.default(pager);
      this._keyboard = new _Keyboard2.default(pager);
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      var pager = this.context.pager;


      pager.addFrame((0, _reactDom.findDOMNode)(this));

      // set frame size initially and then based on certain pager events
      this._setFrameSize();
      pager.on('viewChange', this._setFrameSize);
      pager.on('hydrated', this._setFrameSize);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(_ref) {
      var autoSize = _ref.autoSize,
          accessibility = _ref.accessibility;

      // update any options that have changed
      if (this.props.autoSize !== autoSize || this.props.accessibility !== accessibility) {
        this.context.pager.setOptions({ autoSize: autoSize, accessibility: accessibility });
        this._hydrate = true;
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(nextProps) {
      if (this._hydrate) {
        this.context.pager.hydrate();
        this._hydrate = false;
      }
    }
  }, {
    key: '_getFrameStyle',
    value: function _getFrameStyle() {
      var springConfig = this.props.springConfig;
      var _state = this.state,
          width = _state.width,
          height = _state.height,
          instant = _state.instant;

      return {
        maxWidth: instant ? width : (0, _reactMotion.spring)(width, springConfig),
        height: instant ? height : (0, _reactMotion.spring)(height, springConfig)
      };
    }
  }, {
    key: '_renderFrame',
    value: function _renderFrame(style) {
      var pager = this.context.pager;
      var _props2 = this.props,
          tag = _props2.tag,
          accessibility = _props2.accessibility;

      var props = (0, _specialAssign2.default)(_extends({}, this._swipe.getEvents(), this._keyboard.getEvents(), {
        tabIndex: accessibility ? 0 : null
      }), this.props, checkedProps);

      return (0, _react.createElement)(tag, _extends({}, props, {
        style: _extends({}, style, props.style)
      }));
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var autoSize = this.props.autoSize;
      var height = this.state.height;

      var style = {
        position: 'relative',
        overflow: 'hidden'
      };

      if (autoSize) {
        return _react2.default.createElement(
          _reactMotion.Motion,
          { style: this._getFrameStyle() },
          function (dimensions) {
            if ((autoSize === true || autoSize === 'width') && dimensions.maxWidth) {
              style.maxWidth = dimensions.maxWidth;
            }
            if ((autoSize === true || autoSize === 'height') && dimensions.height) {
              style.height = dimensions.height;
            }
            return _this2._renderFrame(style);
          }
        );
      } else {
        return this._renderFrame(style);
      }
    }
  }]);

  return Frame;
}(_react.Component);

Frame.contextTypes = {
  pager: _propTypes2.default.instanceOf(_Pager2.default)
};
Frame.propTypes = checkedProps;
Frame.defaultProps = {
  tag: 'div',
  autoSize: false,
  accessibility: true,
  springConfig: _reactMotion.presets.noWobble
};
exports.default = Frame;
module.exports = exports['default'];