'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullscreenExit = exports.FullscreenEnter = exports.Close = exports.ChevronRight = exports.ChevronLeft = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _glam = require('glam');

var _glam2 = _interopRequireDefault(_glam);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }
// @jsx glam


var Svg = function Svg(_ref) {
  var size = _ref.size,
      props = _objectWithoutProperties(_ref, ['size']);

  return (0, _glam2.default)('svg', _extends({
    role: 'presentation',
    viewBox: '0 0 24 24',
    css: {
      display: 'inline-block',
      fill: 'currentColor',
      height: size,
      stroke: 'currentColor',
      strokeWidth: 0,
      width: size
    }
  }, props));
};

var ChevronLeft = function ChevronLeft(_ref2) {
  var _ref2$size = _ref2.size,
      size = _ref2$size === undefined ? 32 : _ref2$size,
      props = _objectWithoutProperties(_ref2, ['size']);

  return (0, _glam2.default)(
    Svg,
    _extends({ size: size }, props),
    (0, _glam2.default)('path', { d: 'M15.422 16.078l-1.406 1.406-6-6 6-6 1.406 1.406-4.594 4.594z' })
  );
};
exports.ChevronLeft = ChevronLeft;
var ChevronRight = function ChevronRight(_ref3) {
  var _ref3$size = _ref3.size,
      size = _ref3$size === undefined ? 32 : _ref3$size,
      props = _objectWithoutProperties(_ref3, ['size']);

  return (0, _glam2.default)(
    Svg,
    _extends({ size: size }, props),
    (0, _glam2.default)('path', { d: 'M9.984 6l6 6-6 6-1.406-1.406 4.594-4.594-4.594-4.594z' })
  );
};
exports.ChevronRight = ChevronRight;
var Close = function Close(_ref4) {
  var _ref4$size = _ref4.size,
      size = _ref4$size === undefined ? 32 : _ref4$size,
      props = _objectWithoutProperties(_ref4, ['size']);

  return (0, _glam2.default)(
    Svg,
    _extends({ size: size }, props),
    (0, _glam2.default)('path', { d: 'M18.984 6.422l-5.578 5.578 5.578 5.578-1.406 1.406-5.578-5.578-5.578 5.578-1.406-1.406 5.578-5.578-5.578-5.578 1.406-1.406 5.578 5.578 5.578-5.578z' })
  );
};
exports.Close = Close;
var FullscreenEnter = function FullscreenEnter(_ref5) {
  var _ref5$size = _ref5.size,
      size = _ref5$size === undefined ? 32 : _ref5$size,
      props = _objectWithoutProperties(_ref5, ['size']);

  return (0, _glam2.default)(
    Svg,
    _extends({ size: size }, props),
    (0, _glam2.default)('path', { d: 'M14.016 5.016h4.969v4.969h-1.969v-3h-3v-1.969zM17.016 17.016v-3h1.969v4.969h-4.969v-1.969h3zM5.016 9.984v-4.969h4.969v1.969h-3v3h-1.969zM6.984 14.016v3h3v1.969h-4.969v-4.969h1.969z' })
  );
};
exports.FullscreenEnter = FullscreenEnter;
var FullscreenExit = function FullscreenExit(_ref6) {
  var _ref6$size = _ref6.size,
      size = _ref6$size === undefined ? 32 : _ref6$size,
      props = _objectWithoutProperties(_ref6, ['size']);

  return (0, _glam2.default)(
    Svg,
    _extends({ size: size }, props),
    (0, _glam2.default)('path', { d: 'M15.984 8.016h3v1.969h-4.969v-4.969h1.969v3zM14.016 18.984v-4.969h4.969v1.969h-3v3h-1.969zM8.016 8.016v-3h1.969v4.969h-4.969v-1.969h3zM5.016 15.984v-1.969h4.969v4.969h-1.969v-3h-3z' })
  );
};
exports.FullscreenExit = FullscreenExit;